# Clause 52 BBI allocations: NZGP 1.1 HVDC Allocation Tiwai Stays re-run

*Generated: 2026-01-16 14:28:33.289559, sddp2tpm version: 1.17.0,
 User: davisc*

[TOC]

## Allocations

<div class="container" style="max-width: 1000px;">
<div class="row">
<div class="col-md-4">
<h3>Customer allocations</h3>
<p><i>Output file: allocations.csv</i></p>
<div class="table-responsive" style="max-height: 500px; overflow: auto;">
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th></th>
      <th>Allocation (%)</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>NZ Aluminium Smelters Ltd</th>
      <td>16.58%</td>
    </tr>
    <tr>
      <th>Vector Ltd</th>
      <td>16.55%</td>
    </tr>
    <tr>
      <th>Orion New Zealand Ltd</th>
      <td>11.21%</td>
    </tr>
    <tr>
      <th>Powerco Ltd</th>
      <td>8.60%</td>
    </tr>
    <tr>
      <th>Wellington Electricity Lines Ltd</th>
      <td>4.24%</td>
    </tr>
    <tr>
      <th>Aurora Energy Ltd</th>
      <td>3.67%</td>
    </tr>
    <tr>
      <th>PowerNet Ltd</th>
      <td>2.75%</td>
    </tr>
    <tr>
      <th>Alpine Energy Ltd</th>
      <td>2.64%</td>
    </tr>
    <tr>
      <th>Unison Networks Ltd</th>
      <td>2.53%</td>
    </tr>
    <tr>
      <th>Genesis Energy Ltd</th>
      <td>2.49%</td>
    </tr>
    <tr>
      <th>WEL Networks Ltd</th>
      <td>2.30%</td>
    </tr>
    <tr>
      <th>Mainpower New Zealand Ltd</th>
      <td>2.09%</td>
    </tr>
    <tr>
      <th>Network Tasman Ltd</th>
      <td>1.90%</td>
    </tr>
    <tr>
      <th>Mercury SPV Ltd</th>
      <td>1.76%</td>
    </tr>
    <tr>
      <th>Meridian Energy Ltd</th>
      <td>1.73%</td>
    </tr>
    <tr>
      <th>MEL (West Wind) Ltd</th>
      <td>1.57%</td>
    </tr>
    <tr>
      <th>EA Networks</th>
      <td>1.57%</td>
    </tr>
    <tr>
      <th>Northpower Ltd</th>
      <td>1.53%</td>
    </tr>
    <tr>
      <th>Waverly Wind Farm Ltd</th>
      <td>1.38%</td>
    </tr>
    <tr>
      <th>Marlborough Lines Ltd</th>
      <td>1.30%</td>
    </tr>
    <tr>
      <th>Tararua Wind Power</th>
      <td>1.28%</td>
    </tr>
    <tr>
      <th>Counties Power Ltd</th>
      <td>1.17%</td>
    </tr>
    <tr>
      <th>OtagoNet</th>
      <td>1.15%</td>
    </tr>
    <tr>
      <th>Network Waitaki Ltd</th>
      <td>0.91%</td>
    </tr>
    <tr>
      <th>New Zealand Steel Ltd</th>
      <td>0.87%</td>
    </tr>
    <tr>
      <th>Waipa Networks Ltd</th>
      <td>0.81%</td>
    </tr>
    <tr>
      <th>MEL (Te Apiti) Ltd</th>
      <td>0.79%</td>
    </tr>
    <tr>
      <th>Contact Energy Ltd</th>
      <td>0.63%</td>
    </tr>
    <tr>
      <th>Eastland Network Ltd</th>
      <td>0.56%</td>
    </tr>
    <tr>
      <th>Electra Ltd</th>
      <td>0.50%</td>
    </tr>
    <tr>
      <th>The Lines Company Ltd</th>
      <td>0.47%</td>
    </tr>
    <tr>
      <th>Westpower Ltd</th>
      <td>0.41%</td>
    </tr>
    <tr>
      <th>Nova Energy Ltd</th>
      <td>0.35%</td>
    </tr>
    <tr>
      <th>Horizon Energy Distribution Ltd</th>
      <td>0.28%</td>
    </tr>
    <tr>
      <th>Whareroa Cogeneration Ltd</th>
      <td>0.28%</td>
    </tr>
    <tr>
      <th>Centralines Ltd</th>
      <td>0.22%</td>
    </tr>
    <tr>
      <th>Daiken Southland Ltd</th>
      <td>0.19%</td>
    </tr>
    <tr>
      <th>Nelson Electricity Ltd</th>
      <td>0.16%</td>
    </tr>
    <tr>
      <th>Scanpower Ltd</th>
      <td>0.16%</td>
    </tr>
    <tr>
      <th>Buller Electricity Ltd</th>
      <td>0.12%</td>
    </tr>
    <tr>
      <th>Pan Pac Forest Product Ltd</th>
      <td>0.12%</td>
    </tr>
    <tr>
      <th>Winstone Pulp International</th>
      <td>0.07%</td>
    </tr>
    <tr>
      <th>Top Energy Ltd</th>
      <td>0.03%</td>
    </tr>
    <tr>
      <th>Beach Energy Resources NZ (Holdings) Ltd</th>
      <td>0.03%</td>
    </tr>
    <tr>
      <th>Methanex New Zealand Ltd</th>
      <td>0.02%</td>
    </tr>
    <tr>
      <th>OMV NZ Production Ltd</th>
      <td>0.01%</td>
    </tr>
    <tr>
      <th>KiwiRail Holdings Ltd</th>
      <td>0.01%</td>
    </tr>
    <tr>
      <th>GTL Energy New Zealand Ltd</th>
      <td>0.00%</td>
    </tr>
    <tr>
      <th>Southpark Utilities Ltd</th>
      <td>0.00%</td>
    </tr>
  </tbody>
</table>
</div>
</div>
<div class="col-md-4">
<h3>Regional customer group allocations</h3>
<p><i>Output file: final_group_alloc.csv</i></p>
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th></th>
      <th>Allocation (%)</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>SI_Non-industrial</th>
      <td>46.59%</td>
    </tr>
    <tr>
      <th>NI_Non-industrial</th>
      <td>40.85%</td>
    </tr>
    <tr>
      <th>NI_wind</th>
      <td>8.50%</td>
    </tr>
    <tr>
      <th>NI_peaker</th>
      <td>3.46%</td>
    </tr>
    <tr>
      <th>NI_cogen</th>
      <td>0.28%</td>
    </tr>
    <tr>
      <th>NI_Industrial</th>
      <td>0.26%</td>
    </tr>
    <tr>
      <th>SI_load_with_gen</th>
      <td>0.06%</td>
    </tr>
  </tbody>
</table>
</div>
<div class="col-md-4">
<h3>Regional demand and supply allocations</h3>
<p><i>Output file: region_supply_demand_alloc.csv</i></p>
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th></th>
      <th></th>
      <th>Allocation (%)</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>SI</th>
      <th>demand</th>
      <td>46.65%</td>
    </tr>
    <tr>
      <th rowspan="2" valign="top">NI</th>
      <th>demand</th>
      <td>41.11%</td>
    </tr>
    <tr>
      <th>supply</th>
      <td>12.24%</td>
    </tr>
    <tr>
      <th>SI</th>
      <th>supply</th>
      <td>0.00%</td>
    </tr>
  </tbody>
</table>
</div>
</div>
</div>
<br>

----

## Working tables

### Wind repowering adjustments for generator PVEMBD

According to the TPM[^step_loads], benefits due to large steps in future generation 
should not be included when determining starting allocations.  Plants not already 
committed are already excluded in the input `plants.csv`. However, 
several existing wind farms are assumed to undergo repowering at set times
in the future.  While it is reasonable to include future benefits due to the *current*
capacity of these plants, we should not include *future* increases to capacity of
these wind farms.

In SDDP wind farm repowering is handled by replacing the existing wind farm with a
new plant with increased capacity.  To exclude benefits do to increases in capacity, 
generator PVEMBD for repowered plants is multiplied by the ratio of the original 
capacity to the repowered capacity.

*Output file: repower_adj.csv*

<div class="container" style="max-width: 800px;">
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th></th>
      <th>Capacity_MW</th>
      <th>Replaces</th>
      <th>orig_cap</th>
      <th>adj_factor</th>
    </tr>
    <tr>
      <th>plant</th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>MillCrk_Rpwr</th>
      <td>105.0</td>
      <td>MillCreek</td>
      <td>60.00</td>
      <td>0.571429</td>
    </tr>
    <tr>
      <th>TaraW1_Rpwr</th>
      <td>100.8</td>
      <td>TaraW1</td>
      <td>34.32</td>
      <td>0.340476</td>
    </tr>
    <tr>
      <th>TaraW2_Rpwr</th>
      <td>140.0</td>
      <td>TaraW2</td>
      <td>33.66</td>
      <td>0.240429</td>
    </tr>
    <tr>
      <th>TaraW3_Rpwr</th>
      <td>125.0</td>
      <td>TaraWd3</td>
      <td>93.00</td>
      <td>0.744000</td>
    </tr>
    <tr>
      <th>TeApiti_Rpwr</th>
      <td>220.0</td>
      <td>TeApiti</td>
      <td>90.80</td>
      <td>0.412727</td>
    </tr>
    <tr>
      <th>TRrHau_Rpwr</th>
      <td>82.0</td>
      <td>TeRereHau</td>
      <td>16.50</td>
      <td>0.201220</td>
    </tr>
    <tr>
      <th>TRrHau3_Rpwr</th>
      <td>82.0</td>
      <td>TeRereHau3</td>
      <td>16.00</td>
      <td>0.195122</td>
    </tr>
    <tr>
      <th>TRrHau4_Rpwr</th>
      <td>81.0</td>
      <td>TeRereHau4</td>
      <td>16.00</td>
      <td>0.197531</td>
    </tr>
    <tr>
      <th>TeUku_Rpwr</th>
      <td>110.0</td>
      <td>TeUku</td>
      <td>64.40</td>
      <td>0.585455</td>
    </tr>
    <tr>
      <th>WstWnd_Rpwr</th>
      <td>250.0</td>
      <td>WestWind</td>
      <td>142.60</td>
      <td>0.570400</td>
    </tr>
    <tr>
      <th>Mahiner_Rpwr</th>
      <td>50.0</td>
      <td>Mahiner_s1</td>
      <td>36.00</td>
      <td>0.720000</td>
    </tr>
    <tr>
      <th>WhtHll_Rpwr</th>
      <td>115.0</td>
      <td>WhiteHill</td>
      <td>58.00</td>
      <td>0.504348</td>
    </tr>
  </tbody>
</table>
</div>
<br>



### Step load adjustments for consumer PVEMBD

According to the TPM[^step_loads], benefits due to large
steps in future demand should not be included when determining allocations.

At each bus with identified step loads we multiply load benefits by:

\[\textrm{step load adjustment} = 1 - \frac{\textrm{PV step loads}}{\textrm{PV total loads}}\],
where PV indicates the present value of these loads summed over the BBI investment period.
Step loads for each market scenario are provided in the input file 
`sddp2tpm_data/data/step_loads.csv`, and the total load
comes from the `demxba` SDDP output. 

The consumer benefit table below is the `consumer_pvembd.csv` output from clause52 
postprocessing.

<br>
<div class="container" style="max-width: 1400px;">
<div class="row">
<div class="col-md-4">
<h4>Step load adjustment factor</h4>
<p><i>Output file: step_load_adj.csv</i></p>
<div class="table-responsive" style="max-height: 500px; overflow: auto;">
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th>bus</th>
      <th>ALB220</th>
    </tr>
    <tr>
      <th>edgs_name</th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>disruptive</th>
      <td>1.0</td>
    </tr>
    <tr>
      <th>environmental</th>
      <td>1.0</td>
    </tr>
    <tr>
      <th>global</th>
      <td>1.0</td>
    </tr>
    <tr>
      <th>growth</th>
      <td>1.0</td>
    </tr>
    <tr>
      <th>reference</th>
      <td>1.0</td>
    </tr>
  </tbody>
</table>
</div>
</div>
<div class="col-md-4">
<h4>Consumer benefits</h4>
<div class="table-responsive" style="max-height: 500px; overflow: auto;">
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th></th>
      <th>ALB220</th>
    </tr>
    <tr>
      <th>edgs_name</th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>disruptive</th>
      <td>5.756021e+06</td>
    </tr>
    <tr>
      <th>environmental</th>
      <td>4.202968e+06</td>
    </tr>
    <tr>
      <th>global</th>
      <td>7.910879e+06</td>
    </tr>
    <tr>
      <th>growth</th>
      <td>5.714959e+06</td>
    </tr>
    <tr>
      <th>reference</th>
      <td>6.595356e+05</td>
    </tr>
  </tbody>
</table>
</div>
</div>
<div class="col-md-4">
<h4 id="step-load-adjusted-consumer-benefits">Step load adjusted consumer benefits</h4>
<div class="table-responsive" style="max-height: 500px; overflow: auto;">
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th></th>
      <th>ALB220</th>
    </tr>
    <tr>
      <th>edgs_name</th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>disruptive</th>
      <td>5.756021e+06</td>
    </tr>
    <tr>
      <th>environmental</th>
      <td>4.202968e+06</td>
    </tr>
    <tr>
      <th>global</th>
      <td>7.910879e+06</td>
    </tr>
    <tr>
      <th>growth</th>
      <td>5.714959e+06</td>
    </tr>
    <tr>
      <th>reference</th>
      <td>6.595356e+05</td>
    </tr>
  </tbody>
</table>
</div>
</div>
</div>
</div>



<br>

### Reallocation of load growth to EDBs at multi-customer nodes

Where there is more than one customer at a node, we attribute the load portion
 of PVEMBD to each customer based on their offtake intra-regional allocator (IRA) as 
 a proportion of the total of all customers' offtake IRAs at that connection location.  
 Where some customers are non-distribution customer and others are electricity 
 distribution businesses (EDB), we assume that the load growth at that connection location is 
 wholly attributable to distributor customers, consistent with our demand forecasts 
 for non-distributor customers, which generally assume no load growth.

 The following table shows the nodes with multiple customers that include both
 EDB and non EDB customers, and the reallocation of load growth to EDBs at these nodes.

For non-EDB customers:
\[alloc_{non-EDB} = \frac{w_{IRA}(PVdemand - PV\Delta demand)}{PVdemand}\]
For EDBs:
\[alloc_{EDB} = alloc_{non-EDB} + \frac{w_{EDB}PV\Delta demand}{PVdemand}\]
, where \(w_{IRA}\) (`ira_weight`) is the customer's IRA offtake divided by the total offtake at that location,
and \(w_{EDB}\) (`edb_weight`) is the EDB's offtake divided by the total EDB offtake at that location.

Nodes affected by this calculation are identified in the input `sddp2tpm_data/data/multi_cust_nodes.csv`.  
The IRA offtakes for each customer/location are from the input `sddp2tpm_data/data/ira.csv`,
and the demand and its growth are determined from the annual demand (averaged over hydro scenarios and weighted over
market scenarios), which is in the clause51 output `bus_annual.pv`.

Because demand growth depends on the market scenario, load reallocation is also
EDGS dependant.

The `alloc` column below scales the
`consumer_pvembd.csv` data from clause52 postprocessing, after summing over the buses for each location.

*Output file: load_reallocation.csv*

<div class="table-responsive container" style="max-height: 500px; overflow: auto;">
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th></th>
      <th></th>
      <th></th>
      <th>offtake</th>
      <th>injection</th>
      <th>load_type</th>
      <th>offtake_loc</th>
      <th>ira_weight</th>
      <th>edb_offtake_loc</th>
      <th>edb_weight</th>
      <th>demand_growth_pv</th>
      <th>demand_pv</th>
      <th>alloc</th>
    </tr>
    <tr>
      <th>edgs_name</th>
      <th>cust_code</th>
      <th>location</th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>disruptive</th>
      <th>POCO</th>
      <th>ARI</th>
      <td>8.394852e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>8.427137e+07</td>
      <td>0.996169</td>
      <td>8.394852e+07</td>
      <td>1.000000</td>
      <td>188.300166</td>
      <td>1530.535625</td>
      <td>0.996640</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>POCO</th>
      <th>ARI</th>
      <td>8.394852e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>8.427137e+07</td>
      <td>0.996169</td>
      <td>8.394852e+07</td>
      <td>1.000000</td>
      <td>165.699860</td>
      <td>1486.572079</td>
      <td>0.996596</td>
    </tr>
    <tr>
      <th>global</th>
      <th>POCO</th>
      <th>ARI</th>
      <td>8.394852e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>8.427137e+07</td>
      <td>0.996169</td>
      <td>8.394852e+07</td>
      <td>1.000000</td>
      <td>114.500409</td>
      <td>1400.667980</td>
      <td>0.996482</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>POCO</th>
      <th>ARI</th>
      <td>8.394852e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>8.427137e+07</td>
      <td>0.996169</td>
      <td>8.394852e+07</td>
      <td>1.000000</td>
      <td>138.878602</td>
      <td>1431.094245</td>
      <td>0.996541</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>POCO</th>
      <th>ARI</th>
      <td>8.394852e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>8.427137e+07</td>
      <td>0.996169</td>
      <td>8.394852e+07</td>
      <td>1.000000</td>
      <td>128.382737</td>
      <td>1419.828842</td>
      <td>0.996515</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>MRPL</th>
      <th>ARI</th>
      <td>3.228442e+05</td>
      <td>8.739429e+08</td>
      <td>Generator</td>
      <td>8.427137e+07</td>
      <td>0.003831</td>
      <td>8.394852e+07</td>
      <td>0.000000</td>
      <td>188.300166</td>
      <td>1530.535625</td>
      <td>0.003360</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>MRPL</th>
      <th>ARI</th>
      <td>3.228442e+05</td>
      <td>8.739429e+08</td>
      <td>Generator</td>
      <td>8.427137e+07</td>
      <td>0.003831</td>
      <td>8.394852e+07</td>
      <td>0.000000</td>
      <td>165.699860</td>
      <td>1486.572079</td>
      <td>0.003404</td>
    </tr>
    <tr>
      <th>global</th>
      <th>MRPL</th>
      <th>ARI</th>
      <td>3.228442e+05</td>
      <td>8.739429e+08</td>
      <td>Generator</td>
      <td>8.427137e+07</td>
      <td>0.003831</td>
      <td>8.394852e+07</td>
      <td>0.000000</td>
      <td>114.500409</td>
      <td>1400.667980</td>
      <td>0.003518</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>MRPL</th>
      <th>ARI</th>
      <td>3.228442e+05</td>
      <td>8.739429e+08</td>
      <td>Generator</td>
      <td>8.427137e+07</td>
      <td>0.003831</td>
      <td>8.394852e+07</td>
      <td>0.000000</td>
      <td>138.878602</td>
      <td>1431.094245</td>
      <td>0.003459</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>MRPL</th>
      <th>ARI</th>
      <td>3.228442e+05</td>
      <td>8.739429e+08</td>
      <td>Generator</td>
      <td>8.427137e+07</td>
      <td>0.003831</td>
      <td>8.394852e+07</td>
      <td>0.000000</td>
      <td>128.382737</td>
      <td>1419.828842</td>
      <td>0.003485</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>POCO</th>
      <th>BPE</th>
      <td>3.594438e+08</td>
      <td>1.554200e+03</td>
      <td>EDB</td>
      <td>3.612948e+08</td>
      <td>0.994877</td>
      <td>3.594438e+08</td>
      <td>1.000000</td>
      <td>843.684460</td>
      <td>5331.057238</td>
      <td>0.995688</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>POCO</th>
      <th>BPE</th>
      <td>3.594438e+08</td>
      <td>1.554200e+03</td>
      <td>EDB</td>
      <td>3.612948e+08</td>
      <td>0.994877</td>
      <td>3.594438e+08</td>
      <td>1.000000</td>
      <td>756.642768</td>
      <td>5186.329688</td>
      <td>0.995624</td>
    </tr>
    <tr>
      <th>global</th>
      <th>POCO</th>
      <th>BPE</th>
      <td>3.594438e+08</td>
      <td>1.554200e+03</td>
      <td>EDB</td>
      <td>3.612948e+08</td>
      <td>0.994877</td>
      <td>3.594438e+08</td>
      <td>1.000000</td>
      <td>352.306189</td>
      <td>4454.330941</td>
      <td>0.995282</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>POCO</th>
      <th>BPE</th>
      <td>3.594438e+08</td>
      <td>1.554200e+03</td>
      <td>EDB</td>
      <td>3.612948e+08</td>
      <td>0.994877</td>
      <td>3.594438e+08</td>
      <td>1.000000</td>
      <td>605.669987</td>
      <td>4844.917198</td>
      <td>0.995517</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>POCO</th>
      <th>BPE</th>
      <td>3.594438e+08</td>
      <td>1.554200e+03</td>
      <td>EDB</td>
      <td>3.612948e+08</td>
      <td>0.994877</td>
      <td>3.594438e+08</td>
      <td>1.000000</td>
      <td>487.693167</td>
      <td>4683.222707</td>
      <td>0.995410</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>TRNZ</th>
      <th>BPE</th>
      <td>1.850996e+06</td>
      <td>6.838000e+02</td>
      <td>Industrial</td>
      <td>3.612948e+08</td>
      <td>0.005123</td>
      <td>3.594438e+08</td>
      <td>0.000000</td>
      <td>843.684460</td>
      <td>5331.057238</td>
      <td>0.004312</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>TRNZ</th>
      <th>BPE</th>
      <td>1.850996e+06</td>
      <td>6.838000e+02</td>
      <td>Industrial</td>
      <td>3.612948e+08</td>
      <td>0.005123</td>
      <td>3.594438e+08</td>
      <td>0.000000</td>
      <td>756.642768</td>
      <td>5186.329688</td>
      <td>0.004376</td>
    </tr>
    <tr>
      <th>global</th>
      <th>TRNZ</th>
      <th>BPE</th>
      <td>1.850996e+06</td>
      <td>6.838000e+02</td>
      <td>Industrial</td>
      <td>3.612948e+08</td>
      <td>0.005123</td>
      <td>3.594438e+08</td>
      <td>0.000000</td>
      <td>352.306189</td>
      <td>4454.330941</td>
      <td>0.004718</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>TRNZ</th>
      <th>BPE</th>
      <td>1.850996e+06</td>
      <td>6.838000e+02</td>
      <td>Industrial</td>
      <td>3.612948e+08</td>
      <td>0.005123</td>
      <td>3.594438e+08</td>
      <td>0.000000</td>
      <td>605.669987</td>
      <td>4844.917198</td>
      <td>0.004483</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>TRNZ</th>
      <th>BPE</th>
      <td>1.850996e+06</td>
      <td>6.838000e+02</td>
      <td>Industrial</td>
      <td>3.612948e+08</td>
      <td>0.005123</td>
      <td>3.594438e+08</td>
      <td>0.000000</td>
      <td>487.693167</td>
      <td>4683.222707</td>
      <td>0.004590</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>DUNE</th>
      <th>CYD</th>
      <td>5.553553e+06</td>
      <td>4.880548e+07</td>
      <td>EDB</td>
      <td>5.736523e+06</td>
      <td>0.968104</td>
      <td>5.553553e+06</td>
      <td>1.000000</td>
      <td>120.999927</td>
      <td>240.701533</td>
      <td>0.984138</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>DUNE</th>
      <th>CYD</th>
      <td>5.553553e+06</td>
      <td>4.880548e+07</td>
      <td>EDB</td>
      <td>5.736523e+06</td>
      <td>0.968104</td>
      <td>5.553553e+06</td>
      <td>1.000000</td>
      <td>100.719154</td>
      <td>216.873804</td>
      <td>0.982917</td>
    </tr>
    <tr>
      <th>global</th>
      <th>DUNE</th>
      <th>CYD</th>
      <td>5.553553e+06</td>
      <td>4.880548e+07</td>
      <td>EDB</td>
      <td>5.736523e+06</td>
      <td>0.968104</td>
      <td>5.553553e+06</td>
      <td>1.000000</td>
      <td>92.442908</td>
      <td>190.434980</td>
      <td>0.983587</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>DUNE</th>
      <th>CYD</th>
      <td>5.553553e+06</td>
      <td>4.880548e+07</td>
      <td>EDB</td>
      <td>5.736523e+06</td>
      <td>0.968104</td>
      <td>5.553553e+06</td>
      <td>1.000000</td>
      <td>85.521132</td>
      <td>188.499761</td>
      <td>0.982575</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>DUNE</th>
      <th>CYD</th>
      <td>5.553553e+06</td>
      <td>4.880548e+07</td>
      <td>EDB</td>
      <td>5.736523e+06</td>
      <td>0.968104</td>
      <td>5.553553e+06</td>
      <td>1.000000</td>
      <td>81.695628</td>
      <td>184.676921</td>
      <td>0.982214</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>CTCT</th>
      <th>CYD</th>
      <td>1.829704e+05</td>
      <td>2.149593e+09</td>
      <td>Generator</td>
      <td>5.736523e+06</td>
      <td>0.031896</td>
      <td>5.553553e+06</td>
      <td>0.000000</td>
      <td>120.999927</td>
      <td>240.701533</td>
      <td>0.015862</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>CTCT</th>
      <th>CYD</th>
      <td>1.829704e+05</td>
      <td>2.149593e+09</td>
      <td>Generator</td>
      <td>5.736523e+06</td>
      <td>0.031896</td>
      <td>5.553553e+06</td>
      <td>0.000000</td>
      <td>100.719154</td>
      <td>216.873804</td>
      <td>0.017083</td>
    </tr>
    <tr>
      <th>global</th>
      <th>CTCT</th>
      <th>CYD</th>
      <td>1.829704e+05</td>
      <td>2.149593e+09</td>
      <td>Generator</td>
      <td>5.736523e+06</td>
      <td>0.031896</td>
      <td>5.553553e+06</td>
      <td>0.000000</td>
      <td>92.442908</td>
      <td>190.434980</td>
      <td>0.016413</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>CTCT</th>
      <th>CYD</th>
      <td>1.829704e+05</td>
      <td>2.149593e+09</td>
      <td>Generator</td>
      <td>5.736523e+06</td>
      <td>0.031896</td>
      <td>5.553553e+06</td>
      <td>0.000000</td>
      <td>85.521132</td>
      <td>188.499761</td>
      <td>0.017425</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>CTCT</th>
      <th>CYD</th>
      <td>1.829704e+05</td>
      <td>2.149593e+09</td>
      <td>Generator</td>
      <td>5.736523e+06</td>
      <td>0.031896</td>
      <td>5.553553e+06</td>
      <td>0.000000</td>
      <td>81.695628</td>
      <td>184.676921</td>
      <td>0.017786</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>COUP</th>
      <th>GLN</th>
      <td>1.686322e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>6.257407e+08</td>
      <td>0.269492</td>
      <td>1.686322e+08</td>
      <td>1.000000</td>
      <td>672.792882</td>
      <td>14036.125876</td>
      <td>0.304508</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>COUP</th>
      <th>GLN</th>
      <td>1.686322e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>6.257407e+08</td>
      <td>0.269492</td>
      <td>1.686322e+08</td>
      <td>1.000000</td>
      <td>575.704197</td>
      <td>13330.401741</td>
      <td>0.301041</td>
    </tr>
    <tr>
      <th>global</th>
      <th>COUP</th>
      <th>GLN</th>
      <td>1.686322e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>6.257407e+08</td>
      <td>0.269492</td>
      <td>1.686322e+08</td>
      <td>1.000000</td>
      <td>330.077475</td>
      <td>12864.627305</td>
      <td>0.288235</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>COUP</th>
      <th>GLN</th>
      <td>1.686322e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>6.257407e+08</td>
      <td>0.269492</td>
      <td>1.686322e+08</td>
      <td>1.000000</td>
      <td>528.158407</td>
      <td>13613.561347</td>
      <td>0.297833</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>COUP</th>
      <th>GLN</th>
      <td>1.686322e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>6.257407e+08</td>
      <td>0.269492</td>
      <td>1.686322e+08</td>
      <td>1.000000</td>
      <td>433.849482</td>
      <td>13502.258360</td>
      <td>0.292965</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>NZST</th>
      <th>GLN</th>
      <td>4.571085e+08</td>
      <td>9.569720e+04</td>
      <td>Industrial</td>
      <td>6.257407e+08</td>
      <td>0.730508</td>
      <td>1.686322e+08</td>
      <td>0.000000</td>
      <td>672.792882</td>
      <td>14036.125876</td>
      <td>0.695492</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>NZST</th>
      <th>GLN</th>
      <td>4.571085e+08</td>
      <td>9.569720e+04</td>
      <td>Industrial</td>
      <td>6.257407e+08</td>
      <td>0.730508</td>
      <td>1.686322e+08</td>
      <td>0.000000</td>
      <td>575.704197</td>
      <td>13330.401741</td>
      <td>0.698959</td>
    </tr>
    <tr>
      <th>global</th>
      <th>NZST</th>
      <th>GLN</th>
      <td>4.571085e+08</td>
      <td>9.569720e+04</td>
      <td>Industrial</td>
      <td>6.257407e+08</td>
      <td>0.730508</td>
      <td>1.686322e+08</td>
      <td>0.000000</td>
      <td>330.077475</td>
      <td>12864.627305</td>
      <td>0.711765</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>NZST</th>
      <th>GLN</th>
      <td>4.571085e+08</td>
      <td>9.569720e+04</td>
      <td>Industrial</td>
      <td>6.257407e+08</td>
      <td>0.730508</td>
      <td>1.686322e+08</td>
      <td>0.000000</td>
      <td>528.158407</td>
      <td>13613.561347</td>
      <td>0.702167</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>NZST</th>
      <th>GLN</th>
      <td>4.571085e+08</td>
      <td>9.569720e+04</td>
      <td>Industrial</td>
      <td>6.257407e+08</td>
      <td>0.730508</td>
      <td>1.686322e+08</td>
      <td>0.000000</td>
      <td>433.849482</td>
      <td>13502.258360</td>
      <td>0.707035</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>WELE</th>
      <th>HAM</th>
      <td>7.576371e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>7.591904e+08</td>
      <td>0.997954</td>
      <td>7.576371e+08</td>
      <td>1.000000</td>
      <td>-1655.974364</td>
      <td>7060.321840</td>
      <td>0.997474</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>WELE</th>
      <th>HAM</th>
      <td>7.576371e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>7.591904e+08</td>
      <td>0.997954</td>
      <td>7.576371e+08</td>
      <td>1.000000</td>
      <td>-1600.365947</td>
      <td>7162.737320</td>
      <td>0.997497</td>
    </tr>
    <tr>
      <th>global</th>
      <th>WELE</th>
      <th>HAM</th>
      <td>7.576371e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>7.591904e+08</td>
      <td>0.997954</td>
      <td>7.576371e+08</td>
      <td>1.000000</td>
      <td>-2217.856732</td>
      <td>5962.102998</td>
      <td>0.997193</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>WELE</th>
      <th>HAM</th>
      <td>7.576371e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>7.591904e+08</td>
      <td>0.997954</td>
      <td>7.576371e+08</td>
      <td>1.000000</td>
      <td>-1634.810034</td>
      <td>6970.189435</td>
      <td>0.997474</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>WELE</th>
      <th>HAM</th>
      <td>7.576371e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>7.591904e+08</td>
      <td>0.997954</td>
      <td>7.576371e+08</td>
      <td>1.000000</td>
      <td>-1896.244465</td>
      <td>6565.839527</td>
      <td>0.997363</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>TRNZ</th>
      <th>HAM</th>
      <td>1.553306e+06</td>
      <td>1.624120e+04</td>
      <td>Industrial</td>
      <td>7.591904e+08</td>
      <td>0.002046</td>
      <td>7.576371e+08</td>
      <td>0.000000</td>
      <td>-1655.974364</td>
      <td>7060.321840</td>
      <td>0.002526</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>TRNZ</th>
      <th>HAM</th>
      <td>1.553306e+06</td>
      <td>1.624120e+04</td>
      <td>Industrial</td>
      <td>7.591904e+08</td>
      <td>0.002046</td>
      <td>7.576371e+08</td>
      <td>0.000000</td>
      <td>-1600.365947</td>
      <td>7162.737320</td>
      <td>0.002503</td>
    </tr>
    <tr>
      <th>global</th>
      <th>TRNZ</th>
      <th>HAM</th>
      <td>1.553306e+06</td>
      <td>1.624120e+04</td>
      <td>Industrial</td>
      <td>7.591904e+08</td>
      <td>0.002046</td>
      <td>7.576371e+08</td>
      <td>0.000000</td>
      <td>-2217.856732</td>
      <td>5962.102998</td>
      <td>0.002807</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>TRNZ</th>
      <th>HAM</th>
      <td>1.553306e+06</td>
      <td>1.624120e+04</td>
      <td>Industrial</td>
      <td>7.591904e+08</td>
      <td>0.002046</td>
      <td>7.576371e+08</td>
      <td>0.000000</td>
      <td>-1634.810034</td>
      <td>6970.189435</td>
      <td>0.002526</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>TRNZ</th>
      <th>HAM</th>
      <td>1.553306e+06</td>
      <td>1.624120e+04</td>
      <td>Industrial</td>
      <td>7.591904e+08</td>
      <td>0.002046</td>
      <td>7.576371e+08</td>
      <td>0.000000</td>
      <td>-1896.244465</td>
      <td>6565.839527</td>
      <td>0.002637</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>WELE</th>
      <th>HLY</th>
      <td>1.320209e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.337422e+08</td>
      <td>0.987130</td>
      <td>1.320209e+08</td>
      <td>1.000000</td>
      <td>1141.974002</td>
      <td>3785.492997</td>
      <td>0.991013</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>WELE</th>
      <th>HLY</th>
      <td>1.320209e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.337422e+08</td>
      <td>0.987130</td>
      <td>1.320209e+08</td>
      <td>1.000000</td>
      <td>1141.205356</td>
      <td>3780.755133</td>
      <td>0.991015</td>
    </tr>
    <tr>
      <th>global</th>
      <th>WELE</th>
      <th>HLY</th>
      <td>1.320209e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.337422e+08</td>
      <td>0.987130</td>
      <td>1.320209e+08</td>
      <td>1.000000</td>
      <td>963.643425</td>
      <td>3478.060183</td>
      <td>0.990696</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>WELE</th>
      <th>HLY</th>
      <td>1.320209e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.337422e+08</td>
      <td>0.987130</td>
      <td>1.320209e+08</td>
      <td>1.000000</td>
      <td>1094.041484</td>
      <td>3686.972399</td>
      <td>0.990949</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>WELE</th>
      <th>HLY</th>
      <td>1.320209e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.337422e+08</td>
      <td>0.987130</td>
      <td>1.320209e+08</td>
      <td>1.000000</td>
      <td>1035.840150</td>
      <td>3603.767727</td>
      <td>0.990829</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>GENE</th>
      <th>HLY</th>
      <td>1.721243e+06</td>
      <td>3.981514e+09</td>
      <td>Generator</td>
      <td>1.337422e+08</td>
      <td>0.012870</td>
      <td>1.320209e+08</td>
      <td>0.000000</td>
      <td>1141.974002</td>
      <td>3785.492997</td>
      <td>0.008987</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>GENE</th>
      <th>HLY</th>
      <td>1.721243e+06</td>
      <td>3.981514e+09</td>
      <td>Generator</td>
      <td>1.337422e+08</td>
      <td>0.012870</td>
      <td>1.320209e+08</td>
      <td>0.000000</td>
      <td>1141.205356</td>
      <td>3780.755133</td>
      <td>0.008985</td>
    </tr>
    <tr>
      <th>global</th>
      <th>GENE</th>
      <th>HLY</th>
      <td>1.721243e+06</td>
      <td>3.981514e+09</td>
      <td>Generator</td>
      <td>1.337422e+08</td>
      <td>0.012870</td>
      <td>1.320209e+08</td>
      <td>0.000000</td>
      <td>963.643425</td>
      <td>3478.060183</td>
      <td>0.009304</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>GENE</th>
      <th>HLY</th>
      <td>1.721243e+06</td>
      <td>3.981514e+09</td>
      <td>Generator</td>
      <td>1.337422e+08</td>
      <td>0.012870</td>
      <td>1.320209e+08</td>
      <td>0.000000</td>
      <td>1094.041484</td>
      <td>3686.972399</td>
      <td>0.009051</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>GENE</th>
      <th>HLY</th>
      <td>1.721243e+06</td>
      <td>3.981514e+09</td>
      <td>Generator</td>
      <td>1.337422e+08</td>
      <td>0.012870</td>
      <td>1.320209e+08</td>
      <td>0.000000</td>
      <td>1035.840150</td>
      <td>3603.767727</td>
      <td>0.009171</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>POCO</th>
      <th>HWA</th>
      <td>1.559637e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.329158e+08</td>
      <td>0.669614</td>
      <td>1.559637e+08</td>
      <td>1.000000</td>
      <td>264.367643</td>
      <td>4665.810416</td>
      <td>0.688334</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>POCO</th>
      <th>HWA</th>
      <td>1.559637e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.329158e+08</td>
      <td>0.669614</td>
      <td>1.559637e+08</td>
      <td>1.000000</td>
      <td>216.799565</td>
      <td>4576.970072</td>
      <td>0.685264</td>
    </tr>
    <tr>
      <th>global</th>
      <th>POCO</th>
      <th>HWA</th>
      <td>1.559637e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.329158e+08</td>
      <td>0.669614</td>
      <td>1.559637e+08</td>
      <td>1.000000</td>
      <td>72.644724</td>
      <td>4324.121283</td>
      <td>0.675165</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>POCO</th>
      <th>HWA</th>
      <td>1.559637e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.329158e+08</td>
      <td>0.669614</td>
      <td>1.559637e+08</td>
      <td>1.000000</td>
      <td>166.413213</td>
      <td>4455.416474</td>
      <td>0.681954</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>POCO</th>
      <th>HWA</th>
      <td>1.559637e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.329158e+08</td>
      <td>0.669614</td>
      <td>1.559637e+08</td>
      <td>1.000000</td>
      <td>129.666386</td>
      <td>4398.714615</td>
      <td>0.679353</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>KIWI</th>
      <th>HWA</th>
      <td>2.156468e+05</td>
      <td>1.510133e+08</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.000926</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>264.367643</td>
      <td>4665.810416</td>
      <td>0.000873</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>KIWI</th>
      <th>HWA</th>
      <td>2.156468e+05</td>
      <td>1.510133e+08</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.000926</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>216.799565</td>
      <td>4576.970072</td>
      <td>0.000882</td>
    </tr>
    <tr>
      <th>global</th>
      <th>KIWI</th>
      <th>HWA</th>
      <td>2.156468e+05</td>
      <td>1.510133e+08</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.000926</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>72.644724</td>
      <td>4324.121283</td>
      <td>0.000910</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>KIWI</th>
      <th>HWA</th>
      <td>2.156468e+05</td>
      <td>1.510133e+08</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.000926</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>166.413213</td>
      <td>4455.416474</td>
      <td>0.000891</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>KIWI</th>
      <th>HWA</th>
      <td>2.156468e+05</td>
      <td>1.510133e+08</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.000926</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>129.666386</td>
      <td>4398.714615</td>
      <td>0.000899</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>KUPE</th>
      <th>HWA</th>
      <td>7.673639e+07</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.329460</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>264.367643</td>
      <td>4665.810416</td>
      <td>0.310792</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>KUPE</th>
      <th>HWA</th>
      <td>7.673639e+07</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.329460</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>216.799565</td>
      <td>4576.970072</td>
      <td>0.313854</td>
    </tr>
    <tr>
      <th>global</th>
      <th>KUPE</th>
      <th>HWA</th>
      <td>7.673639e+07</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.329460</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>72.644724</td>
      <td>4324.121283</td>
      <td>0.323925</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>KUPE</th>
      <th>HWA</th>
      <td>7.673639e+07</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.329460</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>166.413213</td>
      <td>4455.416474</td>
      <td>0.317154</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>KUPE</th>
      <th>HWA</th>
      <td>7.673639e+07</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.329460</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>129.666386</td>
      <td>4398.714615</td>
      <td>0.319748</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>POCO</th>
      <th>LTN</th>
      <td>1.612535e+08</td>
      <td>3.497389e+06</td>
      <td>EDB</td>
      <td>1.617480e+08</td>
      <td>0.996942</td>
      <td>1.612535e+08</td>
      <td>1.000000</td>
      <td>1204.354498</td>
      <td>7248.140306</td>
      <td>0.997451</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>POCO</th>
      <th>LTN</th>
      <td>1.612535e+08</td>
      <td>3.497389e+06</td>
      <td>EDB</td>
      <td>1.617480e+08</td>
      <td>0.996942</td>
      <td>1.612535e+08</td>
      <td>1.000000</td>
      <td>967.580283</td>
      <td>6826.254079</td>
      <td>0.997376</td>
    </tr>
    <tr>
      <th>global</th>
      <th>POCO</th>
      <th>LTN</th>
      <td>1.612535e+08</td>
      <td>3.497389e+06</td>
      <td>EDB</td>
      <td>1.617480e+08</td>
      <td>0.996942</td>
      <td>1.612535e+08</td>
      <td>1.000000</td>
      <td>446.834265</td>
      <td>5879.197401</td>
      <td>0.997175</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>POCO</th>
      <th>LTN</th>
      <td>1.612535e+08</td>
      <td>3.497389e+06</td>
      <td>EDB</td>
      <td>1.617480e+08</td>
      <td>0.996942</td>
      <td>1.612535e+08</td>
      <td>1.000000</td>
      <td>705.172627</td>
      <td>6262.415880</td>
      <td>0.997287</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>POCO</th>
      <th>LTN</th>
      <td>1.612535e+08</td>
      <td>3.497389e+06</td>
      <td>EDB</td>
      <td>1.617480e+08</td>
      <td>0.996942</td>
      <td>1.612535e+08</td>
      <td>1.000000</td>
      <td>589.172851</td>
      <td>6114.342360</td>
      <td>0.997237</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>MSVP</th>
      <th>LTN</th>
      <td>4.945487e+05</td>
      <td>5.590925e+08</td>
      <td>Generator</td>
      <td>1.617480e+08</td>
      <td>0.003058</td>
      <td>1.612535e+08</td>
      <td>0.000000</td>
      <td>1204.354498</td>
      <td>7248.140306</td>
      <td>0.002549</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>MSVP</th>
      <th>LTN</th>
      <td>4.945487e+05</td>
      <td>5.590925e+08</td>
      <td>Generator</td>
      <td>1.617480e+08</td>
      <td>0.003058</td>
      <td>1.612535e+08</td>
      <td>0.000000</td>
      <td>967.580283</td>
      <td>6826.254079</td>
      <td>0.002624</td>
    </tr>
    <tr>
      <th>global</th>
      <th>MSVP</th>
      <th>LTN</th>
      <td>4.945487e+05</td>
      <td>5.590925e+08</td>
      <td>Generator</td>
      <td>1.617480e+08</td>
      <td>0.003058</td>
      <td>1.612535e+08</td>
      <td>0.000000</td>
      <td>446.834265</td>
      <td>5879.197401</td>
      <td>0.002825</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>MSVP</th>
      <th>LTN</th>
      <td>4.945487e+05</td>
      <td>5.590925e+08</td>
      <td>Generator</td>
      <td>1.617480e+08</td>
      <td>0.003058</td>
      <td>1.612535e+08</td>
      <td>0.000000</td>
      <td>705.172627</td>
      <td>6262.415880</td>
      <td>0.002713</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>MSVP</th>
      <th>LTN</th>
      <td>4.945487e+05</td>
      <td>5.590925e+08</td>
      <td>Generator</td>
      <td>1.617480e+08</td>
      <td>0.003058</td>
      <td>1.612535e+08</td>
      <td>0.000000</td>
      <td>589.172851</td>
      <td>6114.342360</td>
      <td>0.002763</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>VECT</th>
      <th>PEN</th>
      <td>2.138725e+09</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.155169e+09</td>
      <td>0.992370</td>
      <td>2.138725e+09</td>
      <td>1.000000</td>
      <td>3605.742258</td>
      <td>31048.143930</td>
      <td>0.993256</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>VECT</th>
      <th>PEN</th>
      <td>2.138725e+09</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.155169e+09</td>
      <td>0.992370</td>
      <td>2.138725e+09</td>
      <td>1.000000</td>
      <td>3461.965923</td>
      <td>30779.658342</td>
      <td>0.993228</td>
    </tr>
    <tr>
      <th>global</th>
      <th>VECT</th>
      <th>PEN</th>
      <td>2.138725e+09</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.155169e+09</td>
      <td>0.992370</td>
      <td>2.138725e+09</td>
      <td>1.000000</td>
      <td>1108.458292</td>
      <td>26592.713912</td>
      <td>0.992688</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>VECT</th>
      <th>PEN</th>
      <td>2.138725e+09</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.155169e+09</td>
      <td>0.992370</td>
      <td>2.138725e+09</td>
      <td>1.000000</td>
      <td>2755.195131</td>
      <td>29418.712340</td>
      <td>0.993085</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>VECT</th>
      <th>PEN</th>
      <td>2.138725e+09</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.155169e+09</td>
      <td>0.992370</td>
      <td>2.138725e+09</td>
      <td>1.000000</td>
      <td>2040.183827</td>
      <td>28357.546195</td>
      <td>0.992919</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>SHPK</th>
      <th>PEN</th>
      <td>4.608108e+05</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.000214</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>3605.742258</td>
      <td>31048.143930</td>
      <td>0.000189</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>SHPK</th>
      <th>PEN</th>
      <td>4.608108e+05</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.000214</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>3461.965923</td>
      <td>30779.658342</td>
      <td>0.000190</td>
    </tr>
    <tr>
      <th>global</th>
      <th>SHPK</th>
      <th>PEN</th>
      <td>4.608108e+05</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.000214</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>1108.458292</td>
      <td>26592.713912</td>
      <td>0.000205</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>SHPK</th>
      <th>PEN</th>
      <td>4.608108e+05</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.000214</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>2755.195131</td>
      <td>29418.712340</td>
      <td>0.000194</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>SHPK</th>
      <th>PEN</th>
      <td>4.608108e+05</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.000214</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>2040.183827</td>
      <td>28357.546195</td>
      <td>0.000198</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>TRNZ</th>
      <th>PEN</th>
      <td>1.598319e+07</td>
      <td>1.440000e+01</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.007416</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>3605.742258</td>
      <td>31048.143930</td>
      <td>0.006555</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>TRNZ</th>
      <th>PEN</th>
      <td>1.598319e+07</td>
      <td>1.440000e+01</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.007416</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>3461.965923</td>
      <td>30779.658342</td>
      <td>0.006582</td>
    </tr>
    <tr>
      <th>global</th>
      <th>TRNZ</th>
      <th>PEN</th>
      <td>1.598319e+07</td>
      <td>1.440000e+01</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.007416</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>1108.458292</td>
      <td>26592.713912</td>
      <td>0.007107</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>TRNZ</th>
      <th>PEN</th>
      <td>1.598319e+07</td>
      <td>1.440000e+01</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.007416</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>2755.195131</td>
      <td>29418.712340</td>
      <td>0.006722</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>TRNZ</th>
      <th>PEN</th>
      <td>1.598319e+07</td>
      <td>1.440000e+01</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.007416</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>2040.183827</td>
      <td>28357.546195</td>
      <td>0.006883</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>POCO</th>
      <th>SFD</th>
      <td>1.284703e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.321674e+08</td>
      <td>0.972027</td>
      <td>1.284703e+08</td>
      <td>1.000000</td>
      <td>2264.807364</td>
      <td>5428.210156</td>
      <td>0.983698</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>POCO</th>
      <th>SFD</th>
      <td>1.284703e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.321674e+08</td>
      <td>0.972027</td>
      <td>1.284703e+08</td>
      <td>1.000000</td>
      <td>1621.653109</td>
      <td>4273.440376</td>
      <td>0.982642</td>
    </tr>
    <tr>
      <th>global</th>
      <th>POCO</th>
      <th>SFD</th>
      <td>1.284703e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.321674e+08</td>
      <td>0.972027</td>
      <td>1.284703e+08</td>
      <td>1.000000</td>
      <td>571.803467</td>
      <td>2477.650654</td>
      <td>0.978483</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>POCO</th>
      <th>SFD</th>
      <td>1.284703e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.321674e+08</td>
      <td>0.972027</td>
      <td>1.284703e+08</td>
      <td>1.000000</td>
      <td>965.950565</td>
      <td>2924.423516</td>
      <td>0.981267</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>POCO</th>
      <th>SFD</th>
      <td>1.284703e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.321674e+08</td>
      <td>0.972027</td>
      <td>1.284703e+08</td>
      <td>1.000000</td>
      <td>791.634262</td>
      <td>2733.251772</td>
      <td>0.980129</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>CTCT</th>
      <th>SFD</th>
      <td>3.697118e+06</td>
      <td>9.982725e+08</td>
      <td>Generator</td>
      <td>1.321674e+08</td>
      <td>0.027973</td>
      <td>1.284703e+08</td>
      <td>0.000000</td>
      <td>2264.807364</td>
      <td>5428.210156</td>
      <td>0.016302</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>CTCT</th>
      <th>SFD</th>
      <td>3.697118e+06</td>
      <td>9.982725e+08</td>
      <td>Generator</td>
      <td>1.321674e+08</td>
      <td>0.027973</td>
      <td>1.284703e+08</td>
      <td>0.000000</td>
      <td>1621.653109</td>
      <td>4273.440376</td>
      <td>0.017358</td>
    </tr>
    <tr>
      <th>global</th>
      <th>CTCT</th>
      <th>SFD</th>
      <td>3.697118e+06</td>
      <td>9.982725e+08</td>
      <td>Generator</td>
      <td>1.321674e+08</td>
      <td>0.027973</td>
      <td>1.284703e+08</td>
      <td>0.000000</td>
      <td>571.803467</td>
      <td>2477.650654</td>
      <td>0.021517</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>CTCT</th>
      <th>SFD</th>
      <td>3.697118e+06</td>
      <td>9.982725e+08</td>
      <td>Generator</td>
      <td>1.321674e+08</td>
      <td>0.027973</td>
      <td>1.284703e+08</td>
      <td>0.000000</td>
      <td>965.950565</td>
      <td>2924.423516</td>
      <td>0.018733</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>CTCT</th>
      <th>SFD</th>
      <td>3.697118e+06</td>
      <td>9.982725e+08</td>
      <td>Generator</td>
      <td>1.321674e+08</td>
      <td>0.027973</td>
      <td>1.284703e+08</td>
      <td>0.000000</td>
      <td>791.634262</td>
      <td>2733.251772</td>
      <td>0.019871</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>ALPE</th>
      <th>TKA</th>
      <td>2.009443e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.019261e+07</td>
      <td>0.995138</td>
      <td>2.009443e+07</td>
      <td>1.000000</td>
      <td>1021.925975</td>
      <td>2551.432745</td>
      <td>0.997085</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>ALPE</th>
      <th>TKA</th>
      <td>2.009443e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.019261e+07</td>
      <td>0.995138</td>
      <td>2.009443e+07</td>
      <td>1.000000</td>
      <td>724.135724</td>
      <td>2016.247185</td>
      <td>0.996884</td>
    </tr>
    <tr>
      <th>global</th>
      <th>ALPE</th>
      <th>TKA</th>
      <td>2.009443e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.019261e+07</td>
      <td>0.995138</td>
      <td>2.009443e+07</td>
      <td>1.000000</td>
      <td>269.911181</td>
      <td>1231.323675</td>
      <td>0.996204</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>ALPE</th>
      <th>TKA</th>
      <td>2.009443e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.019261e+07</td>
      <td>0.995138</td>
      <td>2.009443e+07</td>
      <td>1.000000</td>
      <td>432.489110</td>
      <td>1409.427741</td>
      <td>0.996630</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>ALPE</th>
      <th>TKA</th>
      <td>2.009443e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.019261e+07</td>
      <td>0.995138</td>
      <td>2.009443e+07</td>
      <td>1.000000</td>
      <td>358.669539</td>
      <td>1332.013237</td>
      <td>0.996447</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>GENE</th>
      <th>TKA</th>
      <td>9.817760e+04</td>
      <td>1.439613e+08</td>
      <td>Generator</td>
      <td>2.019261e+07</td>
      <td>0.004862</td>
      <td>2.009443e+07</td>
      <td>0.000000</td>
      <td>1021.925975</td>
      <td>2551.432745</td>
      <td>0.002915</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>GENE</th>
      <th>TKA</th>
      <td>9.817760e+04</td>
      <td>1.439613e+08</td>
      <td>Generator</td>
      <td>2.019261e+07</td>
      <td>0.004862</td>
      <td>2.009443e+07</td>
      <td>0.000000</td>
      <td>724.135724</td>
      <td>2016.247185</td>
      <td>0.003116</td>
    </tr>
    <tr>
      <th>global</th>
      <th>GENE</th>
      <th>TKA</th>
      <td>9.817760e+04</td>
      <td>1.439613e+08</td>
      <td>Generator</td>
      <td>2.019261e+07</td>
      <td>0.004862</td>
      <td>2.009443e+07</td>
      <td>0.000000</td>
      <td>269.911181</td>
      <td>1231.323675</td>
      <td>0.003796</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>GENE</th>
      <th>TKA</th>
      <td>9.817760e+04</td>
      <td>1.439613e+08</td>
      <td>Generator</td>
      <td>2.019261e+07</td>
      <td>0.004862</td>
      <td>2.009443e+07</td>
      <td>0.000000</td>
      <td>432.489110</td>
      <td>1409.427741</td>
      <td>0.003370</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>GENE</th>
      <th>TKA</th>
      <td>9.817760e+04</td>
      <td>1.439613e+08</td>
      <td>Generator</td>
      <td>2.019261e+07</td>
      <td>0.004862</td>
      <td>2.009443e+07</td>
      <td>0.000000</td>
      <td>358.669539</td>
      <td>1332.013237</td>
      <td>0.003553</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>WTOM</th>
      <th>TKU</th>
      <td>3.543444e+07</td>
      <td>6.295660e+04</td>
      <td>EDB</td>
      <td>3.808261e+07</td>
      <td>0.930462</td>
      <td>3.543444e+07</td>
      <td>1.000000</td>
      <td>170.743892</td>
      <td>580.356897</td>
      <td>0.950921</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>WTOM</th>
      <th>TKU</th>
      <td>3.543444e+07</td>
      <td>6.295660e+04</td>
      <td>EDB</td>
      <td>3.808261e+07</td>
      <td>0.930462</td>
      <td>3.543444e+07</td>
      <td>1.000000</td>
      <td>141.062334</td>
      <td>529.178627</td>
      <td>0.948999</td>
    </tr>
    <tr>
      <th>global</th>
      <th>WTOM</th>
      <th>TKU</th>
      <td>3.543444e+07</td>
      <td>6.295660e+04</td>
      <td>EDB</td>
      <td>3.808261e+07</td>
      <td>0.930462</td>
      <td>3.543444e+07</td>
      <td>1.000000</td>
      <td>67.722377</td>
      <td>413.287091</td>
      <td>0.941857</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>WTOM</th>
      <th>TKU</th>
      <td>3.543444e+07</td>
      <td>6.295660e+04</td>
      <td>EDB</td>
      <td>3.808261e+07</td>
      <td>0.930462</td>
      <td>3.543444e+07</td>
      <td>1.000000</td>
      <td>89.194657</td>
      <td>436.019061</td>
      <td>0.944687</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>WTOM</th>
      <th>TKU</th>
      <td>3.543444e+07</td>
      <td>6.295660e+04</td>
      <td>EDB</td>
      <td>3.808261e+07</td>
      <td>0.930462</td>
      <td>3.543444e+07</td>
      <td>1.000000</td>
      <td>77.452385</td>
      <td>423.678042</td>
      <td>0.943175</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>GENE</th>
      <th>TKU</th>
      <td>2.648171e+06</td>
      <td>6.998804e+08</td>
      <td>Generator</td>
      <td>3.808261e+07</td>
      <td>0.069538</td>
      <td>3.543444e+07</td>
      <td>0.000000</td>
      <td>170.743892</td>
      <td>580.356897</td>
      <td>0.049079</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>GENE</th>
      <th>TKU</th>
      <td>2.648171e+06</td>
      <td>6.998804e+08</td>
      <td>Generator</td>
      <td>3.808261e+07</td>
      <td>0.069538</td>
      <td>3.543444e+07</td>
      <td>0.000000</td>
      <td>141.062334</td>
      <td>529.178627</td>
      <td>0.051001</td>
    </tr>
    <tr>
      <th>global</th>
      <th>GENE</th>
      <th>TKU</th>
      <td>2.648171e+06</td>
      <td>6.998804e+08</td>
      <td>Generator</td>
      <td>3.808261e+07</td>
      <td>0.069538</td>
      <td>3.543444e+07</td>
      <td>0.000000</td>
      <td>67.722377</td>
      <td>413.287091</td>
      <td>0.058143</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>GENE</th>
      <th>TKU</th>
      <td>2.648171e+06</td>
      <td>6.998804e+08</td>
      <td>Generator</td>
      <td>3.808261e+07</td>
      <td>0.069538</td>
      <td>3.543444e+07</td>
      <td>0.000000</td>
      <td>89.194657</td>
      <td>436.019061</td>
      <td>0.055313</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>GENE</th>
      <th>TKU</th>
      <td>2.648171e+06</td>
      <td>6.998804e+08</td>
      <td>Generator</td>
      <td>3.808261e+07</td>
      <td>0.069538</td>
      <td>3.543444e+07</td>
      <td>0.000000</td>
      <td>77.452385</td>
      <td>423.678042</td>
      <td>0.056825</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>EAST</th>
      <th>TUI</th>
      <td>2.963624e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.963631e+08</td>
      <td>0.999998</td>
      <td>2.963624e+08</td>
      <td>1.000000</td>
      <td>884.550600</td>
      <td>4521.448391</td>
      <td>0.999998</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>EAST</th>
      <th>TUI</th>
      <td>2.963624e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.963631e+08</td>
      <td>0.999998</td>
      <td>2.963624e+08</td>
      <td>1.000000</td>
      <td>799.305732</td>
      <td>4370.992587</td>
      <td>0.999998</td>
    </tr>
    <tr>
      <th>global</th>
      <th>EAST</th>
      <th>TUI</th>
      <td>2.963624e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.963631e+08</td>
      <td>0.999998</td>
      <td>2.963624e+08</td>
      <td>1.000000</td>
      <td>407.814389</td>
      <td>3662.792402</td>
      <td>0.999998</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>EAST</th>
      <th>TUI</th>
      <td>2.963624e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.963631e+08</td>
      <td>0.999998</td>
      <td>2.963624e+08</td>
      <td>1.000000</td>
      <td>671.376118</td>
      <td>4061.827559</td>
      <td>0.999998</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>EAST</th>
      <th>TUI</th>
      <td>2.963624e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.963631e+08</td>
      <td>0.999998</td>
      <td>2.963624e+08</td>
      <td>1.000000</td>
      <td>547.302325</td>
      <td>3893.031350</td>
      <td>0.999998</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>GENE</th>
      <th>TUI</th>
      <td>7.160000e+02</td>
      <td>4.614465e+08</td>
      <td>Generator</td>
      <td>2.963631e+08</td>
      <td>0.000002</td>
      <td>2.963624e+08</td>
      <td>0.000000</td>
      <td>884.550600</td>
      <td>4521.448391</td>
      <td>0.000002</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>GENE</th>
      <th>TUI</th>
      <td>7.160000e+02</td>
      <td>4.614465e+08</td>
      <td>Generator</td>
      <td>2.963631e+08</td>
      <td>0.000002</td>
      <td>2.963624e+08</td>
      <td>0.000000</td>
      <td>799.305732</td>
      <td>4370.992587</td>
      <td>0.000002</td>
    </tr>
    <tr>
      <th>global</th>
      <th>GENE</th>
      <th>TUI</th>
      <td>7.160000e+02</td>
      <td>4.614465e+08</td>
      <td>Generator</td>
      <td>2.963631e+08</td>
      <td>0.000002</td>
      <td>2.963624e+08</td>
      <td>0.000000</td>
      <td>407.814389</td>
      <td>3662.792402</td>
      <td>0.000002</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>GENE</th>
      <th>TUI</th>
      <td>7.160000e+02</td>
      <td>4.614465e+08</td>
      <td>Generator</td>
      <td>2.963631e+08</td>
      <td>0.000002</td>
      <td>2.963624e+08</td>
      <td>0.000000</td>
      <td>671.376118</td>
      <td>4061.827559</td>
      <td>0.000002</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>GENE</th>
      <th>TUI</th>
      <td>7.160000e+02</td>
      <td>4.614465e+08</td>
      <td>Generator</td>
      <td>2.963631e+08</td>
      <td>0.000002</td>
      <td>2.963624e+08</td>
      <td>0.000000</td>
      <td>547.302325</td>
      <td>3893.031350</td>
      <td>0.000002</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>ALPE</th>
      <th>TWZ</th>
      <td>1.587970e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.469411</td>
      <td>2.869365e+07</td>
      <td>0.553422</td>
      <td>111.716642</td>
      <td>458.050818</td>
      <td>0.489901</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>ALPE</th>
      <th>TWZ</th>
      <td>1.587970e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.469411</td>
      <td>2.869365e+07</td>
      <td>0.553422</td>
      <td>94.148397</td>
      <td>426.568841</td>
      <td>0.487953</td>
    </tr>
    <tr>
      <th>global</th>
      <th>ALPE</th>
      <th>TWZ</th>
      <td>1.587970e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.469411</td>
      <td>2.869365e+07</td>
      <td>0.553422</td>
      <td>37.207417</td>
      <td>327.916876</td>
      <td>0.478944</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>ALPE</th>
      <th>TWZ</th>
      <td>1.587970e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.469411</td>
      <td>2.869365e+07</td>
      <td>0.553422</td>
      <td>69.101730</td>
      <td>372.083892</td>
      <td>0.485013</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>ALPE</th>
      <th>TWZ</th>
      <td>1.587970e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.469411</td>
      <td>2.869365e+07</td>
      <td>0.553422</td>
      <td>53.914142</td>
      <td>352.634030</td>
      <td>0.482256</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>WATA</th>
      <th>TWZ</th>
      <td>1.281395e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.378786</td>
      <td>2.869365e+07</td>
      <td>0.446578</td>
      <td>111.716642</td>
      <td>458.050818</td>
      <td>0.395320</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>WATA</th>
      <th>TWZ</th>
      <td>1.281395e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.378786</td>
      <td>2.869365e+07</td>
      <td>0.446578</td>
      <td>94.148397</td>
      <td>426.568841</td>
      <td>0.393749</td>
    </tr>
    <tr>
      <th>global</th>
      <th>WATA</th>
      <th>TWZ</th>
      <td>1.281395e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.378786</td>
      <td>2.869365e+07</td>
      <td>0.446578</td>
      <td>37.207417</td>
      <td>327.916876</td>
      <td>0.386478</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>WATA</th>
      <th>TWZ</th>
      <td>1.281395e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.378786</td>
      <td>2.869365e+07</td>
      <td>0.446578</td>
      <td>69.101730</td>
      <td>372.083892</td>
      <td>0.391376</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>WATA</th>
      <th>TWZ</th>
      <td>1.281395e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.378786</td>
      <td>2.869365e+07</td>
      <td>0.446578</td>
      <td>53.914142</td>
      <td>352.634030</td>
      <td>0.389151</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>MERI</th>
      <th>TWZ</th>
      <td>5.135323e+06</td>
      <td>0.000000e+00</td>
      <td>Generator</td>
      <td>3.382897e+07</td>
      <td>0.151803</td>
      <td>2.869365e+07</td>
      <td>0.000000</td>
      <td>111.716642</td>
      <td>458.050818</td>
      <td>0.114779</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>MERI</th>
      <th>TWZ</th>
      <td>5.135323e+06</td>
      <td>0.000000e+00</td>
      <td>Generator</td>
      <td>3.382897e+07</td>
      <td>0.151803</td>
      <td>2.869365e+07</td>
      <td>0.000000</td>
      <td>94.148397</td>
      <td>426.568841</td>
      <td>0.118298</td>
    </tr>
    <tr>
      <th>global</th>
      <th>MERI</th>
      <th>TWZ</th>
      <td>5.135323e+06</td>
      <td>0.000000e+00</td>
      <td>Generator</td>
      <td>3.382897e+07</td>
      <td>0.151803</td>
      <td>2.869365e+07</td>
      <td>0.000000</td>
      <td>37.207417</td>
      <td>327.916876</td>
      <td>0.134578</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>MERI</th>
      <th>TWZ</th>
      <td>5.135323e+06</td>
      <td>0.000000e+00</td>
      <td>Generator</td>
      <td>3.382897e+07</td>
      <td>0.151803</td>
      <td>2.869365e+07</td>
      <td>0.000000</td>
      <td>69.101730</td>
      <td>372.083892</td>
      <td>0.123610</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>MERI</th>
      <th>TWZ</th>
      <td>5.135323e+06</td>
      <td>0.000000e+00</td>
      <td>Generator</td>
      <td>3.382897e+07</td>
      <td>0.151803</td>
      <td>2.869365e+07</td>
      <td>0.000000</td>
      <td>53.914142</td>
      <td>352.634030</td>
      <td>0.128593</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>SCAN</th>
      <th>WDV</th>
      <td>1.317270e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.383992e+07</td>
      <td>0.951790</td>
      <td>1.317270e+07</td>
      <td>1.000000</td>
      <td>90.874584</td>
      <td>350.259673</td>
      <td>0.964298</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>SCAN</th>
      <th>WDV</th>
      <td>1.317270e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.383992e+07</td>
      <td>0.951790</td>
      <td>1.317270e+07</td>
      <td>1.000000</td>
      <td>67.124858</td>
      <td>307.254347</td>
      <td>0.962322</td>
    </tr>
    <tr>
      <th>global</th>
      <th>SCAN</th>
      <th>WDV</th>
      <td>1.317270e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.383992e+07</td>
      <td>0.951790</td>
      <td>1.317270e+07</td>
      <td>1.000000</td>
      <td>21.912604</td>
      <td>229.652837</td>
      <td>0.956390</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>SCAN</th>
      <th>WDV</th>
      <td>1.317270e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.383992e+07</td>
      <td>0.951790</td>
      <td>1.317270e+07</td>
      <td>1.000000</td>
      <td>39.854260</td>
      <td>251.498863</td>
      <td>0.959430</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>SCAN</th>
      <th>WDV</th>
      <td>1.317270e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.383992e+07</td>
      <td>0.951790</td>
      <td>1.317270e+07</td>
      <td>1.000000</td>
      <td>31.636784</td>
      <td>241.971650</td>
      <td>0.958093</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>MELT</th>
      <th>WDV</th>
      <td>6.672206e+05</td>
      <td>2.520301e+08</td>
      <td>Generator</td>
      <td>1.383992e+07</td>
      <td>0.048210</td>
      <td>1.317270e+07</td>
      <td>0.000000</td>
      <td>90.874584</td>
      <td>350.259673</td>
      <td>0.035702</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>MELT</th>
      <th>WDV</th>
      <td>6.672206e+05</td>
      <td>2.520301e+08</td>
      <td>Generator</td>
      <td>1.383992e+07</td>
      <td>0.048210</td>
      <td>1.317270e+07</td>
      <td>0.000000</td>
      <td>67.124858</td>
      <td>307.254347</td>
      <td>0.037678</td>
    </tr>
    <tr>
      <th>global</th>
      <th>MELT</th>
      <th>WDV</th>
      <td>6.672206e+05</td>
      <td>2.520301e+08</td>
      <td>Generator</td>
      <td>1.383992e+07</td>
      <td>0.048210</td>
      <td>1.317270e+07</td>
      <td>0.000000</td>
      <td>21.912604</td>
      <td>229.652837</td>
      <td>0.043610</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>MELT</th>
      <th>WDV</th>
      <td>6.672206e+05</td>
      <td>2.520301e+08</td>
      <td>Generator</td>
      <td>1.383992e+07</td>
      <td>0.048210</td>
      <td>1.317270e+07</td>
      <td>0.000000</td>
      <td>39.854260</td>
      <td>251.498863</td>
      <td>0.040570</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>MELT</th>
      <th>WDV</th>
      <td>6.672206e+05</td>
      <td>2.520301e+08</td>
      <td>Generator</td>
      <td>1.383992e+07</td>
      <td>0.048210</td>
      <td>1.317270e+07</td>
      <td>0.000000</td>
      <td>31.636784</td>
      <td>241.971650</td>
      <td>0.041907</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>UNIS</th>
      <th>WRK</th>
      <td>9.726822e+06</td>
      <td>1.904989e+08</td>
      <td>EDB</td>
      <td>9.795753e+06</td>
      <td>0.992963</td>
      <td>9.726822e+06</td>
      <td>1.000000</td>
      <td>292.383651</td>
      <td>2988.741272</td>
      <td>0.993652</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>UNIS</th>
      <th>WRK</th>
      <td>9.726822e+06</td>
      <td>1.904989e+08</td>
      <td>EDB</td>
      <td>9.795753e+06</td>
      <td>0.992963</td>
      <td>9.726822e+06</td>
      <td>1.000000</td>
      <td>266.130159</td>
      <td>2950.139192</td>
      <td>0.993598</td>
    </tr>
    <tr>
      <th>global</th>
      <th>UNIS</th>
      <th>WRK</th>
      <td>9.726822e+06</td>
      <td>1.904989e+08</td>
      <td>EDB</td>
      <td>9.795753e+06</td>
      <td>0.992963</td>
      <td>9.726822e+06</td>
      <td>1.000000</td>
      <td>45.764238</td>
      <td>2569.065260</td>
      <td>0.993089</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>UNIS</th>
      <th>WRK</th>
      <td>9.726822e+06</td>
      <td>1.904989e+08</td>
      <td>EDB</td>
      <td>9.795753e+06</td>
      <td>0.992963</td>
      <td>9.726822e+06</td>
      <td>1.000000</td>
      <td>173.251304</td>
      <td>2777.064955</td>
      <td>0.993402</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>UNIS</th>
      <th>WRK</th>
      <td>9.726822e+06</td>
      <td>1.904989e+08</td>
      <td>EDB</td>
      <td>9.795753e+06</td>
      <td>0.992963</td>
      <td>9.726822e+06</td>
      <td>1.000000</td>
      <td>116.386595</td>
      <td>2695.737584</td>
      <td>0.993267</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>CTCT</th>
      <th>WRK</th>
      <td>6.893100e+04</td>
      <td>1.036159e+09</td>
      <td>Generator</td>
      <td>9.795753e+06</td>
      <td>0.007037</td>
      <td>9.726822e+06</td>
      <td>0.000000</td>
      <td>292.383651</td>
      <td>2988.741272</td>
      <td>0.006348</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>CTCT</th>
      <th>WRK</th>
      <td>6.893100e+04</td>
      <td>1.036159e+09</td>
      <td>Generator</td>
      <td>9.795753e+06</td>
      <td>0.007037</td>
      <td>9.726822e+06</td>
      <td>0.000000</td>
      <td>266.130159</td>
      <td>2950.139192</td>
      <td>0.006402</td>
    </tr>
    <tr>
      <th>global</th>
      <th>CTCT</th>
      <th>WRK</th>
      <td>6.893100e+04</td>
      <td>1.036159e+09</td>
      <td>Generator</td>
      <td>9.795753e+06</td>
      <td>0.007037</td>
      <td>9.726822e+06</td>
      <td>0.000000</td>
      <td>45.764238</td>
      <td>2569.065260</td>
      <td>0.006911</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>CTCT</th>
      <th>WRK</th>
      <td>6.893100e+04</td>
      <td>1.036159e+09</td>
      <td>Generator</td>
      <td>9.795753e+06</td>
      <td>0.007037</td>
      <td>9.726822e+06</td>
      <td>0.000000</td>
      <td>173.251304</td>
      <td>2777.064955</td>
      <td>0.006598</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>CTCT</th>
      <th>WRK</th>
      <td>6.893100e+04</td>
      <td>1.036159e+09</td>
      <td>Generator</td>
      <td>9.795753e+06</td>
      <td>0.007037</td>
      <td>9.726822e+06</td>
      <td>0.000000</td>
      <td>116.386595</td>
      <td>2695.737584</td>
      <td>0.006733</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>POCO</th>
      <th>WVY</th>
      <td>2.235968e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.280212e+07</td>
      <td>0.980596</td>
      <td>2.235968e+07</td>
      <td>1.000000</td>
      <td>108.226157</td>
      <td>416.348434</td>
      <td>0.985640</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>POCO</th>
      <th>WVY</th>
      <td>2.235968e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.280212e+07</td>
      <td>0.980596</td>
      <td>2.235968e+07</td>
      <td>1.000000</td>
      <td>80.769062</td>
      <td>366.387702</td>
      <td>0.984874</td>
    </tr>
    <tr>
      <th>global</th>
      <th>POCO</th>
      <th>WVY</th>
      <td>2.235968e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.280212e+07</td>
      <td>0.980596</td>
      <td>2.235968e+07</td>
      <td>1.000000</td>
      <td>28.797472</td>
      <td>275.166172</td>
      <td>0.982627</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>POCO</th>
      <th>WVY</th>
      <td>2.235968e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.280212e+07</td>
      <td>0.980596</td>
      <td>2.235968e+07</td>
      <td>1.000000</td>
      <td>51.595754</td>
      <td>305.318232</td>
      <td>0.983875</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>POCO</th>
      <th>WVY</th>
      <td>2.235968e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.280212e+07</td>
      <td>0.980596</td>
      <td>2.235968e+07</td>
      <td>1.000000</td>
      <td>41.272074</td>
      <td>292.819452</td>
      <td>0.983331</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>WAV1</th>
      <th>WVY</th>
      <td>4.424450e+05</td>
      <td>4.390789e+08</td>
      <td>Generator</td>
      <td>2.280212e+07</td>
      <td>0.019404</td>
      <td>2.235968e+07</td>
      <td>0.000000</td>
      <td>108.226157</td>
      <td>416.348434</td>
      <td>0.014360</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>WAV1</th>
      <th>WVY</th>
      <td>4.424450e+05</td>
      <td>4.390789e+08</td>
      <td>Generator</td>
      <td>2.280212e+07</td>
      <td>0.019404</td>
      <td>2.235968e+07</td>
      <td>0.000000</td>
      <td>80.769062</td>
      <td>366.387702</td>
      <td>0.015126</td>
    </tr>
    <tr>
      <th>global</th>
      <th>WAV1</th>
      <th>WVY</th>
      <td>4.424450e+05</td>
      <td>4.390789e+08</td>
      <td>Generator</td>
      <td>2.280212e+07</td>
      <td>0.019404</td>
      <td>2.235968e+07</td>
      <td>0.000000</td>
      <td>28.797472</td>
      <td>275.166172</td>
      <td>0.017373</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>WAV1</th>
      <th>WVY</th>
      <td>4.424450e+05</td>
      <td>4.390789e+08</td>
      <td>Generator</td>
      <td>2.280212e+07</td>
      <td>0.019404</td>
      <td>2.235968e+07</td>
      <td>0.000000</td>
      <td>51.595754</td>
      <td>305.318232</td>
      <td>0.016125</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>WAV1</th>
      <th>WVY</th>
      <td>4.424450e+05</td>
      <td>4.390789e+08</td>
      <td>Generator</td>
      <td>2.280212e+07</td>
      <td>0.019404</td>
      <td>2.235968e+07</td>
      <td>0.000000</td>
      <td>41.272074</td>
      <td>292.819452</td>
      <td>0.016669</td>
    </tr>
  </tbody>
</table>
</div>

<br>

### Regional Customer Groups

This topic is covered by Clause 50 of the TPM.

Regional customer groups (RCG) are obtained by: 

1. seperating the customer connections into the modelled regions.  The modelled regions are groups of substations that are
seperated by transmission constraints being alleviated by the grid investment and 
the HVDC link.

2. classifying the customer connections in these regions as "supply" or "demand" 
depending on the absolute value of the generation and load PVEMBDs for that customer 
connection

3. Separating the demand and supply customer connections into the regional customer
groups based on the type of load or generation.  This supports the goal of providing 
customer allocations that are broadly proportionate to positive net private benefit (NPB)[^NPB].  With this in mind we
create "load_with_gen" and "gen_with_load" RCGs for customer connections that 
have comparable load and generation benefits[^similar].

#### RCGs and their NPBs for this investment

*Output file: all_groups.csv*
<div class="container" style="max-width: 600px;">
<style type="text/css">
#T_32a2f_row0_col1, #T_32a2f_row1_col1, #T_32a2f_row2_col1, #T_32a2f_row3_col1, #T_32a2f_row4_col1, #T_32a2f_row5_col1, #T_32a2f_row6_col1, #T_32a2f_row7_col1, #T_32a2f_row8_col1, #T_32a2f_row9_col1, #T_32a2f_row10_col1 {
  color: black;
}
#T_32a2f_row11_col1, #T_32a2f_row12_col1, #T_32a2f_row13_col1, #T_32a2f_row14_col1, #T_32a2f_row15_col1, #T_32a2f_row16_col1, #T_32a2f_row17_col1, #T_32a2f_row18_col1, #T_32a2f_row19_col1, #T_32a2f_row20_col1, #T_32a2f_row21_col1 {
  color: red;
}
</style>
<table id="T_32a2f" class = "dataframe table table-sm table-striped table-hover">
  <thead>
    <tr>
      <th id="T_32a2f_level0_col0" class="col_heading level0 col0" >prov_group</th>
      <th id="T_32a2f_level0_col1" class="col_heading level0 col1" >npb</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td id="T_32a2f_row0_col0" class="data row0 col0" >NI_Non-industrial</td>
      <td id="T_32a2f_row0_col1" class="data row0 col1" >82346032</td>
    </tr>
    <tr>
      <td id="T_32a2f_row1_col0" class="data row1 col0" >SI_Non-industrial</td>
      <td id="T_32a2f_row1_col1" class="data row1 col1" >65770830</td>
    </tr>
    <tr>
      <td id="T_32a2f_row2_col0" class="data row2 col0" >SI_Industrial</td>
      <td id="T_32a2f_row2_col1" class="data row2 col1" >31663874</td>
    </tr>
    <tr>
      <td id="T_32a2f_row3_col0" class="data row3 col0" >NI_wind</td>
      <td id="T_32a2f_row3_col1" class="data row3 col1" >17778473</td>
    </tr>
    <tr>
      <td id="T_32a2f_row4_col0" class="data row4 col0" >NI_commit</td>
      <td id="T_32a2f_row4_col1" class="data row4 col1" >5026703</td>
    </tr>
    <tr>
      <td id="T_32a2f_row5_col0" class="data row5 col0" >NI_load_with_gen</td>
      <td id="T_32a2f_row5_col1" class="data row5 col1" >3094420</td>
    </tr>
    <tr>
      <td id="T_32a2f_row6_col0" class="data row6 col0" >NI_peaker</td>
      <td id="T_32a2f_row6_col1" class="data row6 col1" >2206010</td>
    </tr>
    <tr>
      <td id="T_32a2f_row7_col0" class="data row7 col0" >NI_cogen</td>
      <td id="T_32a2f_row7_col1" class="data row7 col1" >583257</td>
    </tr>
    <tr>
      <td id="T_32a2f_row8_col0" class="data row8 col0" >NI_Industrial</td>
      <td id="T_32a2f_row8_col1" class="data row8 col1" >538632</td>
    </tr>
    <tr>
      <td id="T_32a2f_row9_col0" class="data row9 col0" >SI_load_with_gen</td>
      <td id="T_32a2f_row9_col1" class="data row9 col1" >133706</td>
    </tr>
    <tr>
      <td id="T_32a2f_row10_col0" class="data row10 col0" >SI_battery</td>
      <td id="T_32a2f_row10_col1" class="data row10 col1" >3547</td>
    </tr>
    <tr>
      <td id="T_32a2f_row11_col0" class="data row11 col0" >NI_solar</td>
      <td id="T_32a2f_row11_col1" class="data row11 col1" >-1966</td>
    </tr>
    <tr>
      <td id="T_32a2f_row12_col0" class="data row12 col0" >SI_peaker</td>
      <td id="T_32a2f_row12_col1" class="data row12 col1" >-2306</td>
    </tr>
    <tr>
      <td id="T_32a2f_row13_col0" class="data row13 col0" >SI_solar</td>
      <td id="T_32a2f_row13_col1" class="data row13 col1" >-2672</td>
    </tr>
    <tr>
      <td id="T_32a2f_row14_col0" class="data row14 col0" >SI_wind</td>
      <td id="T_32a2f_row14_col1" class="data row14 col1" >-7117</td>
    </tr>
    <tr>
      <td id="T_32a2f_row15_col0" class="data row15 col0" >NI_battery</td>
      <td id="T_32a2f_row15_col1" class="data row15 col1" >-20656</td>
    </tr>
    <tr>
      <td id="T_32a2f_row16_col0" class="data row16 col0" >SI_run of river</td>
      <td id="T_32a2f_row16_col1" class="data row16 col1" >-131716</td>
    </tr>
    <tr>
      <td id="T_32a2f_row17_col0" class="data row17 col0" >NI_gen_with_load</td>
      <td id="T_32a2f_row17_col1" class="data row17 col1" >-1061201</td>
    </tr>
    <tr>
      <td id="T_32a2f_row18_col0" class="data row18 col0" >NI_run of river</td>
      <td id="T_32a2f_row18_col1" class="data row18 col1" >-19333361</td>
    </tr>
    <tr>
      <td id="T_32a2f_row19_col0" class="data row19 col0" >NI_geo</td>
      <td id="T_32a2f_row19_col1" class="data row19 col1" >-21330143</td>
    </tr>
    <tr>
      <td id="T_32a2f_row20_col0" class="data row20 col0" >NI_storage</td>
      <td id="T_32a2f_row20_col1" class="data row20 col1" >-55467445</td>
    </tr>
    <tr>
      <td id="T_32a2f_row21_col0" class="data row21 col0" >SI_storage</td>
      <td id="T_32a2f_row21_col1" class="data row21 col1" >-60398041</td>
    </tr>
  </tbody>
</table>

</div>

Clause 47 of the TPM states that to be considered a beneficiary (and hence have 
a cost allocation) for a BBI, they must belong to a RCG that has positive PVEMBD (NPB).

### Benefitting customers and locations

The following table shows the customers and locations that belong to the benefitting RCGs abvove.  
The output file `customers.csv` shows the corresponding table for all 
customer locations before filtering to beneficiaries.

The `load_benefit` column is obtained from [the step-load adjusted consumer PVEMBD](#step-load-adjusted-consumer-benefits) by

 - applying the [load reallocations above](#reallocation-of-load-growth-to-edbs-at-multi-customer-nodes)
    where applicable, and the IRA offtake ratio elsewhere to 
    `consumer_pvembd.csv` output from clause52 postprocessing. 
  
 - taking the weighted sum of EDGS scenarios.

*See the output file: big_load_table.csv for these intermediate values.*

The `gen_benefit` column is obtained by

 - applying the [wind repowering adjustments](#wind-repowering-adjustments-for-generator-pvembd)
  to the 
  `plant_pvembd.csv` output from clause52 postprocessing. 
  
 - taking the weighted sum of EDGS scenarios.

*See the output file: `gen_benefit.csv` for these intermediate values.*


*Output file: bens.csv*
<div class="table-responsive container" style="max-width: 1000px; max-height: 500px; overflow: auto;">
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th></th>
      <th></th>
      <th>load_benefit</th>
      <th>gen_benefit</th>
      <th>pvembd</th>
      <th>dc_delta_lce_pv</th>
      <th>pvembd_with_delta_lce</th>
      <th>prov_group</th>
      <th>ira</th>
      <th>final_group</th>
      <th>npb</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>CHBP</th>
      <th>WPW</th>
      <td>809910</td>
      <td>0</td>
      <td>809910</td>
      <td>-192332</td>
      <td>617579</td>
      <td>NI_Non-industrial</td>
      <td>118763185</td>
      <td>NI_Non-industrial</td>
      <td>470295</td>
    </tr>
    <tr>
      <th rowspan="2" valign="top">COUP</th>
      <th>BOB</th>
      <td>4505795</td>
      <td>0</td>
      <td>4505795</td>
      <td>-952398</td>
      <td>3553397</td>
      <td>NI_Non-industrial</td>
      <td>450970220</td>
      <td>NI_Non-industrial</td>
      <td>1785813</td>
    </tr>
    <tr>
      <th>GLN</th>
      <td>1203025</td>
      <td>0</td>
      <td>1203025</td>
      <td>-565372</td>
      <td>637653</td>
      <td>NI_Non-industrial</td>
      <td>168632240</td>
      <td>NI_Non-industrial</td>
      <td>667773</td>
    </tr>
    <tr>
      <th>EAST</th>
      <th>TUI</th>
      <td>2129363</td>
      <td>0</td>
      <td>2129363</td>
      <td>-635006</td>
      <td>1494357</td>
      <td>NI_Non-industrial</td>
      <td>296362362</td>
      <td>NI_Non-industrial</td>
      <td>1173576</td>
    </tr>
    <tr>
      <th>HORO</th>
      <th>PRM</th>
      <td>1968119</td>
      <td>0</td>
      <td>1968119</td>
      <td>-1034457</td>
      <td>933662</td>
      <td>NI_Non-industrial</td>
      <td>266437495</td>
      <td>NI_Non-industrial</td>
      <td>1055076</td>
    </tr>
    <tr>
      <th rowspan="2" valign="top">HRZE</th>
      <th>EDG</th>
      <td>1034578</td>
      <td>31969</td>
      <td>1066547</td>
      <td>-1171366</td>
      <td>-104820</td>
      <td>NI_Non-industrial</td>
      <td>88624008</td>
      <td>NI_Non-industrial</td>
      <td>350945</td>
    </tr>
    <tr>
      <th>WAI</th>
      <td>828994</td>
      <td>0</td>
      <td>828994</td>
      <td>-24716</td>
      <td>804277</td>
      <td>NI_Non-industrial</td>
      <td>60929346</td>
      <td>NI_Non-industrial</td>
      <td>241276</td>
    </tr>
    <tr>
      <th rowspan="3" valign="top">NPOW</th>
      <th>BRB</th>
      <td>760533</td>
      <td>0</td>
      <td>760533</td>
      <td>-1512793</td>
      <td>-752260</td>
      <td>NI_Non-industrial</td>
      <td>110508619</td>
      <td>NI_Non-industrial</td>
      <td>437607</td>
    </tr>
    <tr>
      <th>MPE</th>
      <td>3597827</td>
      <td>0</td>
      <td>3597827</td>
      <td>-2306262</td>
      <td>1291565</td>
      <td>NI_Non-industrial</td>
      <td>592125310</td>
      <td>NI_Non-industrial</td>
      <td>2344779</td>
    </tr>
    <tr>
      <th>MTO</th>
      <td>895367</td>
      <td>0</td>
      <td>895367</td>
      <td>-495510</td>
      <td>399857</td>
      <td>NI_Non-industrial</td>
      <td>106716681</td>
      <td>NI_Non-industrial</td>
      <td>422591</td>
    </tr>
    <tr>
      <th rowspan="26" valign="top">POCO</th>
      <th>ARI</th>
      <td>696105</td>
      <td>0</td>
      <td>696105</td>
      <td>0</td>
      <td>696105</td>
      <td>NI_Non-industrial</td>
      <td>83948525</td>
      <td>NI_Non-industrial</td>
      <td>332431</td>
    </tr>
    <tr>
      <th>BPE</th>
      <td>2460210</td>
      <td>779320</td>
      <td>3239530</td>
      <td>-1406166</td>
      <td>1833364</td>
      <td>NI_Non-industrial</td>
      <td>359443839</td>
      <td>NI_Non-industrial</td>
      <td>1423375</td>
    </tr>
    <tr>
      <th>BRK</th>
      <td>778884</td>
      <td>0</td>
      <td>778884</td>
      <td>-486215</td>
      <td>292669</td>
      <td>NI_Non-industrial</td>
      <td>126067921</td>
      <td>NI_Non-industrial</td>
      <td>499221</td>
    </tr>
    <tr>
      <th>CST</th>
      <td>1697986</td>
      <td>0</td>
      <td>1697986</td>
      <td>-465899</td>
      <td>1232087</td>
      <td>NI_Non-industrial</td>
      <td>286468037</td>
      <td>NI_Non-industrial</td>
      <td>1134395</td>
    </tr>
    <tr>
      <th>GYT</th>
      <td>364237</td>
      <td>0</td>
      <td>364237</td>
      <td>-164622</td>
      <td>199615</td>
      <td>NI_Non-industrial</td>
      <td>59823757</td>
      <td>NI_Non-industrial</td>
      <td>236898</td>
    </tr>
    <tr>
      <th>HIN</th>
      <td>742708</td>
      <td>0</td>
      <td>742708</td>
      <td>-476743</td>
      <td>265965</td>
      <td>NI_Non-industrial</td>
      <td>202915666</td>
      <td>NI_Non-industrial</td>
      <td>803533</td>
    </tr>
    <tr>
      <th>HUI</th>
      <td>715860</td>
      <td>0</td>
      <td>715860</td>
      <td>-242093</td>
      <td>473767</td>
      <td>NI_Non-industrial</td>
      <td>136054019</td>
      <td>NI_Non-industrial</td>
      <td>538765</td>
    </tr>
    <tr>
      <th>HWA</th>
      <td>986136</td>
      <td>0</td>
      <td>986136</td>
      <td>-256847</td>
      <td>729289</td>
      <td>NI_Non-industrial</td>
      <td>155963716</td>
      <td>NI_Non-industrial</td>
      <td>617606</td>
    </tr>
    <tr>
      <th>KIN</th>
      <td>2285186</td>
      <td>-792941</td>
      <td>1492245</td>
      <td>-171427</td>
      <td>1320818</td>
      <td>NI_Non-industrial</td>
      <td>391264560</td>
      <td>NI_Non-industrial</td>
      <td>1549383</td>
    </tr>
    <tr>
      <th>KMO</th>
      <td>1061966</td>
      <td>0</td>
      <td>1061966</td>
      <td>-32157</td>
      <td>1029809</td>
      <td>NI_Non-industrial</td>
      <td>97444722</td>
      <td>NI_Non-industrial</td>
      <td>385875</td>
    </tr>
    <tr>
      <th>KPU</th>
      <td>1324363</td>
      <td>0</td>
      <td>1324363</td>
      <td>-497276</td>
      <td>827087</td>
      <td>NI_Non-industrial</td>
      <td>224171551</td>
      <td>NI_Non-industrial</td>
      <td>887705</td>
    </tr>
    <tr>
      <th>LTN</th>
      <td>3053281</td>
      <td>765110</td>
      <td>3818391</td>
      <td>-567004</td>
      <td>3251387</td>
      <td>NI_Non-industrial</td>
      <td>161253460</td>
      <td>NI_Non-industrial</td>
      <td>638553</td>
    </tr>
    <tr>
      <th>MGM</th>
      <td>448433</td>
      <td>0</td>
      <td>448433</td>
      <td>-128921</td>
      <td>319512</td>
      <td>NI_Non-industrial</td>
      <td>81582749</td>
      <td>NI_Non-industrial</td>
      <td>323062</td>
    </tr>
    <tr>
      <th>MST</th>
      <td>1471655</td>
      <td>0</td>
      <td>1471655</td>
      <td>-682211</td>
      <td>789444</td>
      <td>NI_Non-industrial</td>
      <td>224615871</td>
      <td>NI_Non-industrial</td>
      <td>889465</td>
    </tr>
    <tr>
      <th>MTM</th>
      <td>1709780</td>
      <td>0</td>
      <td>1709780</td>
      <td>-117232</td>
      <td>1592549</td>
      <td>NI_Non-industrial</td>
      <td>280356924</td>
      <td>NI_Non-industrial</td>
      <td>1110196</td>
    </tr>
    <tr>
      <th>MTN</th>
      <td>1019152</td>
      <td>0</td>
      <td>1019152</td>
      <td>-145127</td>
      <td>874025</td>
      <td>NI_Non-industrial</td>
      <td>89891719</td>
      <td>NI_Non-industrial</td>
      <td>355965</td>
    </tr>
    <tr>
      <th>MTR</th>
      <td>281500</td>
      <td>0</td>
      <td>281500</td>
      <td>-54180</td>
      <td>227320</td>
      <td>NI_Non-industrial</td>
      <td>33516454</td>
      <td>NI_Non-industrial</td>
      <td>132723</td>
    </tr>
    <tr>
      <th>OKN</th>
      <td>58302</td>
      <td>0</td>
      <td>58302</td>
      <td>-13318</td>
      <td>44984</td>
      <td>NI_Non-industrial</td>
      <td>8438888</td>
      <td>NI_Non-industrial</td>
      <td>33417</td>
    </tr>
    <tr>
      <th>OPK</th>
      <td>212749</td>
      <td>0</td>
      <td>212749</td>
      <td>-78324</td>
      <td>134425</td>
      <td>NI_Non-industrial</td>
      <td>49177704</td>
      <td>NI_Non-industrial</td>
      <td>194741</td>
    </tr>
    <tr>
      <th>PAO</th>
      <td>1317047</td>
      <td>0</td>
      <td>1317047</td>
      <td>-434701</td>
      <td>882347</td>
      <td>NI_Non-industrial</td>
      <td>201452000</td>
      <td>NI_Non-industrial</td>
      <td>797737</td>
    </tr>
    <tr>
      <th>SFD</th>
      <td>2017989</td>
      <td>0</td>
      <td>2017989</td>
      <td>-206695</td>
      <td>1811294</td>
      <td>NI_Non-industrial</td>
      <td>128470310</td>
      <td>NI_Non-industrial</td>
      <td>508734</td>
    </tr>
    <tr>
      <th>TMI</th>
      <td>1440474</td>
      <td>0</td>
      <td>1440474</td>
      <td>-89395</td>
      <td>1351079</td>
      <td>NI_Non-industrial</td>
      <td>232019042</td>
      <td>NI_Non-industrial</td>
      <td>918781</td>
    </tr>
    <tr>
      <th>WGN</th>
      <td>746902</td>
      <td>0</td>
      <td>746902</td>
      <td>-241425</td>
      <td>505476</td>
      <td>NI_Non-industrial</td>
      <td>153001202</td>
      <td>NI_Non-industrial</td>
      <td>605875</td>
    </tr>
    <tr>
      <th>WHU</th>
      <td>1896880</td>
      <td>0</td>
      <td>1896880</td>
      <td>-370490</td>
      <td>1526390</td>
      <td>NI_Non-industrial</td>
      <td>167020169</td>
      <td>NI_Non-industrial</td>
      <td>661389</td>
    </tr>
    <tr>
      <th>WKO</th>
      <td>929094</td>
      <td>0</td>
      <td>929094</td>
      <td>-403095</td>
      <td>525999</td>
      <td>NI_Non-industrial</td>
      <td>182759152</td>
      <td>NI_Non-industrial</td>
      <td>723715</td>
    </tr>
    <tr>
      <th>WVY</th>
      <td>154700</td>
      <td>0</td>
      <td>154700</td>
      <td>-37842</td>
      <td>116858</td>
      <td>NI_Non-industrial</td>
      <td>22359678</td>
      <td>NI_Non-industrial</td>
      <td>88543</td>
    </tr>
    <tr>
      <th rowspan="2" valign="top">SCAN</th>
      <th>DVK</th>
      <td>552735</td>
      <td>0</td>
      <td>552735</td>
      <td>-113344</td>
      <td>439391</td>
      <td>NI_Non-industrial</td>
      <td>70032377</td>
      <td>NI_Non-industrial</td>
      <td>277324</td>
    </tr>
    <tr>
      <th>WDV</th>
      <td>137122</td>
      <td>0</td>
      <td>137122</td>
      <td>-21172</td>
      <td>115950</td>
      <td>NI_Non-industrial</td>
      <td>13172697</td>
      <td>NI_Non-industrial</td>
      <td>52163</td>
    </tr>
    <tr>
      <th rowspan="8" valign="top">UNET</th>
      <th>CPK</th>
      <td>4954967</td>
      <td>0</td>
      <td>4954967</td>
      <td>-2366860</td>
      <td>2588107</td>
      <td>NI_Non-industrial</td>
      <td>746523023</td>
      <td>NI_Non-industrial</td>
      <td>2956184</td>
    </tr>
    <tr>
      <th>GFD</th>
      <td>1950772</td>
      <td>0</td>
      <td>1950772</td>
      <td>-847609</td>
      <td>1103162</td>
      <td>NI_Non-industrial</td>
      <td>276858925</td>
      <td>NI_Non-industrial</td>
      <td>1096344</td>
    </tr>
    <tr>
      <th>HAY</th>
      <td>1023659</td>
      <td>0</td>
      <td>1023659</td>
      <td>-408671</td>
      <td>614988</td>
      <td>NI_Non-industrial</td>
      <td>137895039</td>
      <td>NI_Non-industrial</td>
      <td>546056</td>
    </tr>
    <tr>
      <th>KWA</th>
      <td>854924</td>
      <td>0</td>
      <td>854924</td>
      <td>-445328</td>
      <td>409596</td>
      <td>NI_Non-industrial</td>
      <td>138007126</td>
      <td>NI_Non-industrial</td>
      <td>546499</td>
    </tr>
    <tr>
      <th>MLG</th>
      <td>1665356</td>
      <td>0</td>
      <td>1665356</td>
      <td>-763627</td>
      <td>901729</td>
      <td>NI_Non-industrial</td>
      <td>249483118</td>
      <td>NI_Non-industrial</td>
      <td>987937</td>
    </tr>
    <tr>
      <th>PNI</th>
      <td>638245</td>
      <td>0</td>
      <td>638245</td>
      <td>-210896</td>
      <td>427349</td>
      <td>NI_Non-industrial</td>
      <td>69566475</td>
      <td>NI_Non-industrial</td>
      <td>275479</td>
    </tr>
    <tr>
      <th>TKR</th>
      <td>2840436</td>
      <td>0</td>
      <td>2840436</td>
      <td>-1242620</td>
      <td>1597816</td>
      <td>NI_Non-industrial</td>
      <td>414526547</td>
      <td>NI_Non-industrial</td>
      <td>1641499</td>
    </tr>
    <tr>
      <th>UHT</th>
      <td>770335</td>
      <td>0</td>
      <td>770335</td>
      <td>-400817</td>
      <td>369518</td>
      <td>NI_Non-industrial</td>
      <td>134808207</td>
      <td>NI_Non-industrial</td>
      <td>533832</td>
    </tr>
    <tr>
      <th rowspan="6" valign="top">UNIS</th>
      <th>FHL</th>
      <td>1918551</td>
      <td>0</td>
      <td>1918551</td>
      <td>-608545</td>
      <td>1310005</td>
      <td>NI_Non-industrial</td>
      <td>290947233</td>
      <td>NI_Non-industrial</td>
      <td>1152133</td>
    </tr>
    <tr>
      <th>OWH</th>
      <td>369902</td>
      <td>0</td>
      <td>369902</td>
      <td>-23529</td>
      <td>346373</td>
      <td>NI_Non-industrial</td>
      <td>56623655</td>
      <td>NI_Non-industrial</td>
      <td>224226</td>
    </tr>
    <tr>
      <th>RDF</th>
      <td>1509257</td>
      <td>0</td>
      <td>1509257</td>
      <td>-605840</td>
      <td>903417</td>
      <td>NI_Non-industrial</td>
      <td>283553522</td>
      <td>NI_Non-industrial</td>
      <td>1122854</td>
    </tr>
    <tr>
      <th>ROT</th>
      <td>2081109</td>
      <td>-958678</td>
      <td>1122431</td>
      <td>-94166</td>
      <td>1028265</td>
      <td>NI_Non-industrial</td>
      <td>233401274</td>
      <td>NI_Non-industrial</td>
      <td>924254</td>
    </tr>
    <tr>
      <th>TRK</th>
      <td>241667</td>
      <td>0</td>
      <td>241667</td>
      <td>-15051</td>
      <td>226616</td>
      <td>NI_Non-industrial</td>
      <td>36573785</td>
      <td>NI_Non-industrial</td>
      <td>144830</td>
    </tr>
    <tr>
      <th>WTU</th>
      <td>2521650</td>
      <td>0</td>
      <td>2521650</td>
      <td>-1658430</td>
      <td>863220</td>
      <td>NI_Non-industrial</td>
      <td>435962199</td>
      <td>NI_Non-industrial</td>
      <td>1726383</td>
    </tr>
    <tr>
      <th rowspan="15" valign="top">VECT</th>
      <th>ALB</th>
      <td>4848873</td>
      <td>0</td>
      <td>4848873</td>
      <td>-3618202</td>
      <td>1230670</td>
      <td>NI_Non-industrial</td>
      <td>936458581</td>
      <td>NI_Non-industrial</td>
      <td>3708316</td>
    </tr>
    <tr>
      <th>HEN</th>
      <td>5135301</td>
      <td>0</td>
      <td>5135301</td>
      <td>-1646245</td>
      <td>3489055</td>
      <td>NI_Non-industrial</td>
      <td>524217649</td>
      <td>NI_Non-industrial</td>
      <td>2075869</td>
    </tr>
    <tr>
      <th>HEP</th>
      <td>3740252</td>
      <td>0</td>
      <td>3740252</td>
      <td>-3031423</td>
      <td>708829</td>
      <td>NI_Non-industrial</td>
      <td>615248023</td>
      <td>NI_Non-industrial</td>
      <td>2436343</td>
    </tr>
    <tr>
      <th>HOB</th>
      <td>3625972</td>
      <td>0</td>
      <td>3625972</td>
      <td>-1234621</td>
      <td>2391351</td>
      <td>NI_Non-industrial</td>
      <td>256452850</td>
      <td>NI_Non-industrial</td>
      <td>1015537</td>
    </tr>
    <tr>
      <th>LFD</th>
      <td>297311</td>
      <td>0</td>
      <td>297311</td>
      <td>-28401</td>
      <td>268911</td>
      <td>NI_Non-industrial</td>
      <td>67338357</td>
      <td>NI_Non-industrial</td>
      <td>266656</td>
    </tr>
    <tr>
      <th>MNG</th>
      <td>5551393</td>
      <td>0</td>
      <td>5551393</td>
      <td>-3032879</td>
      <td>2518514</td>
      <td>NI_Non-industrial</td>
      <td>639468930</td>
      <td>NI_Non-industrial</td>
      <td>2532256</td>
    </tr>
    <tr>
      <th>OTA</th>
      <td>2024119</td>
      <td>0</td>
      <td>2024119</td>
      <td>-1058184</td>
      <td>965934</td>
      <td>NI_Non-industrial</td>
      <td>302160261</td>
      <td>NI_Non-industrial</td>
      <td>1196535</td>
    </tr>
    <tr>
      <th>PAK</th>
      <td>4093719</td>
      <td>0</td>
      <td>4093719</td>
      <td>-2172046</td>
      <td>1921672</td>
      <td>NI_Non-industrial</td>
      <td>639923401</td>
      <td>NI_Non-industrial</td>
      <td>2534056</td>
    </tr>
    <tr>
      <th>PEN</th>
      <td>13694835</td>
      <td>0</td>
      <td>13694835</td>
      <td>-7647091</td>
      <td>6047744</td>
      <td>NI_Non-industrial</td>
      <td>2138725360</td>
      <td>NI_Non-industrial</td>
      <td>8469216</td>
    </tr>
    <tr>
      <th>ROS</th>
      <td>4256933</td>
      <td>0</td>
      <td>4256933</td>
      <td>-3326189</td>
      <td>930744</td>
      <td>NI_Non-industrial</td>
      <td>683350587</td>
      <td>NI_Non-industrial</td>
      <td>2706025</td>
    </tr>
    <tr>
      <th>SVL</th>
      <td>3166028</td>
      <td>0</td>
      <td>3166028</td>
      <td>-1204377</td>
      <td>1961651</td>
      <td>NI_Non-industrial</td>
      <td>471206560</td>
      <td>NI_Non-industrial</td>
      <td>1865948</td>
    </tr>
    <tr>
      <th>TAK</th>
      <td>2939062</td>
      <td>0</td>
      <td>2939062</td>
      <td>-1742941</td>
      <td>1196121</td>
      <td>NI_Non-industrial</td>
      <td>522561458</td>
      <td>NI_Non-industrial</td>
      <td>2069310</td>
    </tr>
    <tr>
      <th>WEL</th>
      <td>1174932</td>
      <td>0</td>
      <td>1174932</td>
      <td>-803204</td>
      <td>371728</td>
      <td>NI_Non-industrial</td>
      <td>171754434</td>
      <td>NI_Non-industrial</td>
      <td>680137</td>
    </tr>
    <tr>
      <th>WIR</th>
      <td>3287826</td>
      <td>0</td>
      <td>3287826</td>
      <td>-2288890</td>
      <td>998935</td>
      <td>NI_Non-industrial</td>
      <td>475293776</td>
      <td>NI_Non-industrial</td>
      <td>1882133</td>
    </tr>
    <tr>
      <th>WRD</th>
      <td>3154237</td>
      <td>0</td>
      <td>3154237</td>
      <td>-1002506</td>
      <td>2151730</td>
      <td>NI_Non-industrial</td>
      <td>299016331</td>
      <td>NI_Non-industrial</td>
      <td>1184086</td>
    </tr>
    <tr>
      <th rowspan="2" valign="top">WAIP</th>
      <th>CBG</th>
      <td>2302972</td>
      <td>0</td>
      <td>2302972</td>
      <td>-501256</td>
      <td>1801716</td>
      <td>NI_Non-industrial</td>
      <td>232675179</td>
      <td>NI_Non-industrial</td>
      <td>921379</td>
    </tr>
    <tr>
      <th>TMU</th>
      <td>2216624</td>
      <td>0</td>
      <td>2216624</td>
      <td>-427708</td>
      <td>1788916</td>
      <td>NI_Non-industrial</td>
      <td>195437859</td>
      <td>NI_Non-industrial</td>
      <td>773921</td>
    </tr>
    <tr>
      <th rowspan="3" valign="top">WELE</th>
      <th>HAM</th>
      <td>2691960</td>
      <td>0</td>
      <td>2691960</td>
      <td>-2710123</td>
      <td>-18162</td>
      <td>NI_Non-industrial</td>
      <td>757637063</td>
      <td>NI_Non-industrial</td>
      <td>3000195</td>
    </tr>
    <tr>
      <th>HLY</th>
      <td>1906786</td>
      <td>0</td>
      <td>1906786</td>
      <td>-490171</td>
      <td>1416615</td>
      <td>NI_Non-industrial</td>
      <td>132020946</td>
      <td>NI_Non-industrial</td>
      <td>522795</td>
    </tr>
    <tr>
      <th>TWH</th>
      <td>3347231</td>
      <td>846884</td>
      <td>4194115</td>
      <td>-473891</td>
      <td>3720223</td>
      <td>NI_Non-industrial</td>
      <td>323886040</td>
      <td>NI_Non-industrial</td>
      <td>1282568</td>
    </tr>
    <tr>
      <th rowspan="5" valign="top">WTOM</th>
      <th>HTI</th>
      <td>1360223</td>
      <td>0</td>
      <td>1360223</td>
      <td>-379760</td>
      <td>980462</td>
      <td>NI_Non-industrial</td>
      <td>163348358</td>
      <td>NI_Non-industrial</td>
      <td>646849</td>
    </tr>
    <tr>
      <th>NPK</th>
      <td>152980</td>
      <td>0</td>
      <td>152980</td>
      <td>-28283</td>
      <td>124697</td>
      <td>NI_Non-industrial</td>
      <td>16089458</td>
      <td>NI_Non-industrial</td>
      <td>63713</td>
    </tr>
    <tr>
      <th>OKN</th>
      <td>128733</td>
      <td>0</td>
      <td>128733</td>
      <td>-30788</td>
      <td>97945</td>
      <td>NI_Non-industrial</td>
      <td>18633410</td>
      <td>NI_Non-industrial</td>
      <td>73787</td>
    </tr>
    <tr>
      <th>ONG</th>
      <td>238289</td>
      <td>0</td>
      <td>238289</td>
      <td>-25233</td>
      <td>213056</td>
      <td>NI_Non-industrial</td>
      <td>16322692</td>
      <td>NI_Non-industrial</td>
      <td>64637</td>
    </tr>
    <tr>
      <th>TKU</th>
      <td>229283</td>
      <td>0</td>
      <td>229283</td>
      <td>-136743</td>
      <td>92540</td>
      <td>NI_Non-industrial</td>
      <td>35434435</td>
      <td>NI_Non-industrial</td>
      <td>140318</td>
    </tr>
    <tr>
      <th>CTCT</th>
      <th>WHI</th>
      <td>6669</td>
      <td>-5253</td>
      <td>1417</td>
      <td>-5375</td>
      <td>-3958</td>
      <td>NI_load_with_gen</td>
      <td>1334845</td>
      <td>NI_Non-industrial</td>
      <td>5286</td>
    </tr>
    <tr>
      <th>NZST</th>
      <th>GLN</th>
      <td>2841074</td>
      <td>-1427294</td>
      <td>1413780</td>
      <td>-1636617</td>
      <td>-222837</td>
      <td>NI_load_with_gen</td>
      <td>457108455</td>
      <td>NI_Non-industrial</td>
      <td>1810120</td>
    </tr>
    <tr>
      <th>POCO</th>
      <th>TGA</th>
      <td>3093847</td>
      <td>-1788256</td>
      <td>1305591</td>
      <td>-166822</td>
      <td>1138768</td>
      <td>NI_load_with_gen</td>
      <td>405052947</td>
      <td>NI_Non-industrial</td>
      <td>1603984</td>
    </tr>
    <tr>
      <th>TBOP</th>
      <th>KPA</th>
      <td>252203</td>
      <td>167222</td>
      <td>419425</td>
      <td>-3067</td>
      <td>416358</td>
      <td>NI_load_with_gen</td>
      <td>54214</td>
      <td>NI_Non-industrial</td>
      <td>215</td>
    </tr>
    <tr>
      <th>TOPE</th>
      <th>KOE</th>
      <td>1591651</td>
      <td>-1428660</td>
      <td>162991</td>
      <td>-549944</td>
      <td>-386953</td>
      <td>NI_load_with_gen</td>
      <td>17922872</td>
      <td>NI_Non-industrial</td>
      <td>70973</td>
    </tr>
    <tr>
      <th>UNET</th>
      <th>WIL</th>
      <td>1401262</td>
      <td>1087541</td>
      <td>2488803</td>
      <td>-335763</td>
      <td>2153040</td>
      <td>NI_load_with_gen</td>
      <td>72596450</td>
      <td>NI_Non-industrial</td>
      <td>287477</td>
    </tr>
    <tr>
      <th>KUPE</th>
      <th>HWA</th>
      <td>457039</td>
      <td>0</td>
      <td>457039</td>
      <td>-102956</td>
      <td>354083</td>
      <td>NI_Industrial</td>
      <td>76736389</td>
      <td>NI_Industrial</td>
      <td>52990</td>
    </tr>
    <tr>
      <th>METH</th>
      <th>MNI</th>
      <td>126866</td>
      <td>0</td>
      <td>126866</td>
      <td>-79588</td>
      <td>47278</td>
      <td>NI_Industrial</td>
      <td>49318938</td>
      <td>NI_Industrial</td>
      <td>34057</td>
    </tr>
    <tr>
      <th>OMVP</th>
      <th>MNI</th>
      <td>106079</td>
      <td>0</td>
      <td>106079</td>
      <td>-84689</td>
      <td>21391</td>
      <td>NI_Industrial</td>
      <td>41238189</td>
      <td>NI_Industrial</td>
      <td>28477</td>
    </tr>
    <tr>
      <th>PANP</th>
      <th>WHI</th>
      <td>1746196</td>
      <td>0</td>
      <td>1746196</td>
      <td>-1681321</td>
      <td>64875</td>
      <td>NI_Industrial</td>
      <td>349487222</td>
      <td>NI_Industrial</td>
      <td>241338</td>
    </tr>
    <tr>
      <th>SHPK</th>
      <th>PEN</th>
      <td>2696</td>
      <td>0</td>
      <td>2696</td>
      <td>-1590</td>
      <td>1106</td>
      <td>NI_Industrial</td>
      <td>460811</td>
      <td>NI_Industrial</td>
      <td>318</td>
    </tr>
    <tr>
      <th rowspan="6" valign="top">TRNZ</th>
      <th>BPE</th>
      <td>11121</td>
      <td>0</td>
      <td>11121</td>
      <td>-10626</td>
      <td>495</td>
      <td>NI_Industrial</td>
      <td>1850996</td>
      <td>NI_Industrial</td>
      <td>1278</td>
    </tr>
    <tr>
      <th>HAM</th>
      <td>7067</td>
      <td>0</td>
      <td>7067</td>
      <td>-9352</td>
      <td>-2285</td>
      <td>NI_Industrial</td>
      <td>1553306</td>
      <td>NI_Industrial</td>
      <td>1073</td>
    </tr>
    <tr>
      <th>PEN</th>
      <td>93511</td>
      <td>0</td>
      <td>93511</td>
      <td>-60064</td>
      <td>33447</td>
      <td>NI_Industrial</td>
      <td>15983185</td>
      <td>NI_Industrial</td>
      <td>11037</td>
    </tr>
    <tr>
      <th>SWN</th>
      <td>174221</td>
      <td>0</td>
      <td>174221</td>
      <td>-59714</td>
      <td>114506</td>
      <td>NI_Industrial</td>
      <td>15856896</td>
      <td>NI_Industrial</td>
      <td>10950</td>
    </tr>
    <tr>
      <th>TMN</th>
      <td>66006</td>
      <td>0</td>
      <td>66006</td>
      <td>-12143</td>
      <td>53862</td>
      <td>NI_Industrial</td>
      <td>2034025</td>
      <td>NI_Industrial</td>
      <td>1405</td>
    </tr>
    <tr>
      <th>TNG</th>
      <td>7004</td>
      <td>0</td>
      <td>7004</td>
      <td>-12288</td>
      <td>-5284</td>
      <td>NI_Industrial</td>
      <td>2077821</td>
      <td>NI_Industrial</td>
      <td>1435</td>
    </tr>
    <tr>
      <th>WNST</th>
      <th>TNG</th>
      <td>753071</td>
      <td>0</td>
      <td>753071</td>
      <td>-897913</td>
      <td>-144843</td>
      <td>NI_Industrial</td>
      <td>223407024</td>
      <td>NI_Industrial</td>
      <td>154274</td>
    </tr>
    <tr>
      <th>MELT</th>
      <th>WDV</th>
      <td>5621</td>
      <td>2001998</td>
      <td>2007618</td>
      <td>-6649</td>
      <td>2000969</td>
      <td>NI_wind</td>
      <td>252030144</td>
      <td>NI_wind</td>
      <td>1661219</td>
    </tr>
    <tr>
      <th>MELW</th>
      <th>WWD</th>
      <td>0</td>
      <td>2584724</td>
      <td>2584724</td>
      <td>-2073</td>
      <td>2582650</td>
      <td>NI_wind</td>
      <td>499573780</td>
      <td>NI_wind</td>
      <td>3292865</td>
    </tr>
    <tr>
      <th>MERI</th>
      <th>HRP</th>
      <td>0</td>
      <td>3086454</td>
      <td>3086454</td>
      <td>0</td>
      <td>3086454</td>
      <td>NI_wind</td>
      <td>542000000</td>
      <td>NI_wind</td>
      <td>3572511</td>
    </tr>
    <tr>
      <th>MSVP</th>
      <th>LTN</th>
      <td>8231</td>
      <td>5028166</td>
      <td>5036398</td>
      <td>-347758</td>
      <td>4688640</td>
      <td>NI_wind</td>
      <td>559092523</td>
      <td>NI_wind</td>
      <td>3685174</td>
    </tr>
    <tr>
      <th>TARW</th>
      <th>TWC</th>
      <td>0</td>
      <td>3213575</td>
      <td>3213575</td>
      <td>-252203</td>
      <td>2961372</td>
      <td>NI_wind</td>
      <td>405468001</td>
      <td>NI_wind</td>
      <td>2672581</td>
    </tr>
    <tr>
      <th>WAV1</th>
      <th>WVY</th>
      <td>2460</td>
      <td>2664268</td>
      <td>2666728</td>
      <td>-208341</td>
      <td>2458387</td>
      <td>NI_wind</td>
      <td>439078937</td>
      <td>NI_wind</td>
      <td>2894123</td>
    </tr>
    <tr>
      <th>GENE</th>
      <th>HLY</th>
      <td>17528</td>
      <td>7580003</td>
      <td>7597531</td>
      <td>-2570828</td>
      <td>5026703</td>
      <td>NI_commit</td>
      <td>3981514051</td>
      <td>NI_peaker</td>
      <td>5204031</td>
    </tr>
    <tr>
      <th>CTCT</th>
      <th>SFD</th>
      <td>37204</td>
      <td>1944263</td>
      <td>1981467</td>
      <td>-823224</td>
      <td>1158243</td>
      <td>NI_peaker</td>
      <td>998272522</td>
      <td>NI_peaker</td>
      <td>1304790</td>
    </tr>
    <tr>
      <th rowspan="2" valign="top">TBOP</th>
      <th>JRD</th>
      <td>0</td>
      <td>218839</td>
      <td>218839</td>
      <td>-9050</td>
      <td>209788</td>
      <td>NI_peaker</td>
      <td>261049468</td>
      <td>NI_peaker</td>
      <td>341204</td>
    </tr>
    <tr>
      <th>MKE</th>
      <td>0</td>
      <td>847030</td>
      <td>847030</td>
      <td>-9050</td>
      <td>837979</td>
      <td>NI_peaker</td>
      <td>292787165</td>
      <td>NI_peaker</td>
      <td>382687</td>
    </tr>
    <tr>
      <th>KIWI</th>
      <th>HWA</th>
      <td>1284</td>
      <td>586259</td>
      <td>587543</td>
      <td>-4286</td>
      <td>583257</td>
      <td>NI_cogen</td>
      <td>151013251</td>
      <td>NI_cogen</td>
      <td>583257</td>
    </tr>
    <tr>
      <th rowspan="6" valign="top">ALPE</th>
      <th>BPD</th>
      <td>833569</td>
      <td>0</td>
      <td>833569</td>
      <td>-102527</td>
      <td>731041</td>
      <td>SI_Non-industrial</td>
      <td>50970587</td>
      <td>SI_Non-industrial</td>
      <td>349545</td>
    </tr>
    <tr>
      <th>STU</th>
      <td>924332</td>
      <td>0</td>
      <td>924332</td>
      <td>-134997</td>
      <td>789335</td>
      <td>SI_Non-industrial</td>
      <td>65376640</td>
      <td>SI_Non-industrial</td>
      <td>448338</td>
    </tr>
    <tr>
      <th>TIM</th>
      <td>2840267</td>
      <td>0</td>
      <td>2840267</td>
      <td>-646685</td>
      <td>2193582</td>
      <td>SI_Non-industrial</td>
      <td>365516424</td>
      <td>SI_Non-industrial</td>
      <td>2506628</td>
    </tr>
    <tr>
      <th>TKA</th>
      <td>1288459</td>
      <td>0</td>
      <td>1288459</td>
      <td>-36004</td>
      <td>1252455</td>
      <td>SI_Non-industrial</td>
      <td>20094430</td>
      <td>SI_Non-industrial</td>
      <td>137803</td>
    </tr>
    <tr>
      <th>TMK</th>
      <td>3994367</td>
      <td>0</td>
      <td>3994367</td>
      <td>-511082</td>
      <td>3483285</td>
      <td>SI_Non-industrial</td>
      <td>288301685</td>
      <td>SI_Non-industrial</td>
      <td>1977107</td>
    </tr>
    <tr>
      <th>TWZ</th>
      <td>108052</td>
      <td>0</td>
      <td>108052</td>
      <td>-32684</td>
      <td>75368</td>
      <td>SI_Non-industrial</td>
      <td>15879702</td>
      <td>SI_Non-industrial</td>
      <td>108899</td>
    </tr>
    <tr>
      <th>BUEL</th>
      <th>ORO</th>
      <td>430923</td>
      <td>0</td>
      <td>430923</td>
      <td>-63989</td>
      <td>366934</td>
      <td>SI_Non-industrial</td>
      <td>36293741</td>
      <td>SI_Non-industrial</td>
      <td>248894</td>
    </tr>
    <tr>
      <th rowspan="4" valign="top">DUNE</th>
      <th>CML</th>
      <td>1446844</td>
      <td>0</td>
      <td>1446844</td>
      <td>-369358</td>
      <td>1077486</td>
      <td>SI_Non-industrial</td>
      <td>186460085</td>
      <td>SI_Non-industrial</td>
      <td>1278700</td>
    </tr>
    <tr>
      <th>FKN</th>
      <td>2483582</td>
      <td>0</td>
      <td>2483582</td>
      <td>-497997</td>
      <td>1985585</td>
      <td>SI_Non-industrial</td>
      <td>250403695</td>
      <td>SI_Non-industrial</td>
      <td>1717211</td>
    </tr>
    <tr>
      <th>HWB</th>
      <td>3574790</td>
      <td>-1355059</td>
      <td>2219731</td>
      <td>-154776</td>
      <td>2064955</td>
      <td>SI_Non-industrial</td>
      <td>353586704</td>
      <td>SI_Non-industrial</td>
      <td>2424816</td>
    </tr>
    <tr>
      <th>SDN</th>
      <td>2486037</td>
      <td>0</td>
      <td>2486037</td>
      <td>-135556</td>
      <td>2350480</td>
      <td>SI_Non-industrial</td>
      <td>327432268</td>
      <td>SI_Non-industrial</td>
      <td>2245455</td>
    </tr>
    <tr>
      <th>EASH</th>
      <th>ASB</th>
      <td>4316952</td>
      <td>-382100</td>
      <td>3934852</td>
      <td>-953957</td>
      <td>2980895</td>
      <td>SI_Non-industrial</td>
      <td>478842702</td>
      <td>SI_Non-industrial</td>
      <td>3283793</td>
    </tr>
    <tr>
      <th>MARL</th>
      <th>BLN</th>
      <td>2628922</td>
      <td>0</td>
      <td>2628922</td>
      <td>-630759</td>
      <td>1998162</td>
      <td>SI_Non-industrial</td>
      <td>395910052</td>
      <td>SI_Non-industrial</td>
      <td>2715060</td>
    </tr>
    <tr>
      <th>MERI</th>
      <th>TWZ</th>
      <td>25893</td>
      <td>0</td>
      <td>25893</td>
      <td>-11715</td>
      <td>14177</td>
      <td>SI_Non-industrial</td>
      <td>5135323</td>
      <td>SI_Non-industrial</td>
      <td>35217</td>
    </tr>
    <tr>
      <th rowspan="5" valign="top">MPOW</th>
      <th>ASY</th>
      <td>634275</td>
      <td>0</td>
      <td>634275</td>
      <td>-168892</td>
      <td>465383</td>
      <td>SI_Non-industrial</td>
      <td>88938040</td>
      <td>SI_Non-industrial</td>
      <td>609917</td>
    </tr>
    <tr>
      <th>CUL</th>
      <td>911288</td>
      <td>0</td>
      <td>911288</td>
      <td>-199209</td>
      <td>712078</td>
      <td>SI_Non-industrial</td>
      <td>99424279</td>
      <td>SI_Non-industrial</td>
      <td>681829</td>
    </tr>
    <tr>
      <th>KAI</th>
      <td>885794</td>
      <td>0</td>
      <td>885794</td>
      <td>-266780</td>
      <td>619014</td>
      <td>SI_Non-industrial</td>
      <td>141616030</td>
      <td>SI_Non-industrial</td>
      <td>971170</td>
    </tr>
    <tr>
      <th>SBK</th>
      <td>2843049</td>
      <td>0</td>
      <td>2843049</td>
      <td>-455629</td>
      <td>2387420</td>
      <td>SI_Non-industrial</td>
      <td>249097329</td>
      <td>SI_Non-industrial</td>
      <td>1708252</td>
    </tr>
    <tr>
      <th>WPR</th>
      <td>454373</td>
      <td>0</td>
      <td>454373</td>
      <td>-110149</td>
      <td>344224</td>
      <td>SI_Non-industrial</td>
      <td>56971023</td>
      <td>SI_Non-industrial</td>
      <td>390694</td>
    </tr>
    <tr>
      <th>NELS</th>
      <th>STK</th>
      <td>502171</td>
      <td>0</td>
      <td>502171</td>
      <td>-100639</td>
      <td>401532</td>
      <td>SI_Non-industrial</td>
      <td>49574308</td>
      <td>SI_Non-industrial</td>
      <td>339969</td>
    </tr>
    <tr>
      <th rowspan="7" valign="top">ORON</th>
      <th>APS</th>
      <td>32190</td>
      <td>0</td>
      <td>32190</td>
      <td>-2042</td>
      <td>30147</td>
      <td>SI_Non-industrial</td>
      <td>1048923</td>
      <td>SI_Non-industrial</td>
      <td>7193</td>
    </tr>
    <tr>
      <th>BRY</th>
      <td>6340458</td>
      <td>0</td>
      <td>6340458</td>
      <td>-1298773</td>
      <td>5041685</td>
      <td>SI_Non-industrial</td>
      <td>685869165</td>
      <td>SI_Non-industrial</td>
      <td>4703533</td>
    </tr>
    <tr>
      <th>CLH</th>
      <td>45314</td>
      <td>0</td>
      <td>45314</td>
      <td>-3090</td>
      <td>42224</td>
      <td>SI_Non-industrial</td>
      <td>1773658</td>
      <td>SI_Non-industrial</td>
      <td>12163</td>
    </tr>
    <tr>
      <th>COL</th>
      <td>65559</td>
      <td>0</td>
      <td>65559</td>
      <td>-2217</td>
      <td>63342</td>
      <td>SI_Non-industrial</td>
      <td>1148770</td>
      <td>SI_Non-industrial</td>
      <td>7878</td>
    </tr>
    <tr>
      <th>HOR</th>
      <td>1660331</td>
      <td>0</td>
      <td>1660331</td>
      <td>-294258</td>
      <td>1366073</td>
      <td>SI_Non-industrial</td>
      <td>127109661</td>
      <td>SI_Non-industrial</td>
      <td>871689</td>
    </tr>
    <tr>
      <th>ISL</th>
      <td>18437830</td>
      <td>0</td>
      <td>18437830</td>
      <td>-4637043</td>
      <td>13800787</td>
      <td>SI_Non-industrial</td>
      <td>2524266071</td>
      <td>SI_Non-industrial</td>
      <td>17310836</td>
    </tr>
    <tr>
      <th>KBY</th>
      <td>986550</td>
      <td>0</td>
      <td>986550</td>
      <td>-134879</td>
      <td>851671</td>
      <td>SI_Non-industrial</td>
      <td>77191084</td>
      <td>SI_Non-industrial</td>
      <td>529359</td>
    </tr>
    <tr>
      <th rowspan="3" valign="top">OTNT</th>
      <th>BAL</th>
      <td>1632668</td>
      <td>0</td>
      <td>1632668</td>
      <td>-26684</td>
      <td>1605984</td>
      <td>SI_Non-industrial</td>
      <td>153539403</td>
      <td>SI_Non-industrial</td>
      <td>1052938</td>
    </tr>
    <tr>
      <th>HWB</th>
      <td>333118</td>
      <td>0</td>
      <td>333118</td>
      <td>-13604</td>
      <td>319514</td>
      <td>SI_Non-industrial</td>
      <td>32949122</td>
      <td>SI_Non-industrial</td>
      <td>225957</td>
    </tr>
    <tr>
      <th>NSY</th>
      <td>1697491</td>
      <td>0</td>
      <td>1697491</td>
      <td>-330718</td>
      <td>1366772</td>
      <td>SI_Non-industrial</td>
      <td>163990696</td>
      <td>SI_Non-industrial</td>
      <td>1124610</td>
    </tr>
    <tr>
      <th rowspan="4" valign="top">POWN</th>
      <th>EDN</th>
      <td>1456388</td>
      <td>0</td>
      <td>1456388</td>
      <td>-25942</td>
      <td>1430445</td>
      <td>SI_Non-industrial</td>
      <td>150385634</td>
      <td>SI_Non-industrial</td>
      <td>1031310</td>
    </tr>
    <tr>
      <th>FKN</th>
      <td>364279</td>
      <td>0</td>
      <td>364279</td>
      <td>-58742</td>
      <td>305537</td>
      <td>SI_Non-industrial</td>
      <td>36727941</td>
      <td>SI_Non-industrial</td>
      <td>251872</td>
    </tr>
    <tr>
      <th>GOR</th>
      <td>2131651</td>
      <td>0</td>
      <td>2131651</td>
      <td>-29323</td>
      <td>2102328</td>
      <td>SI_Non-industrial</td>
      <td>169536238</td>
      <td>SI_Non-industrial</td>
      <td>1162641</td>
    </tr>
    <tr>
      <th>INV</th>
      <td>4501274</td>
      <td>0</td>
      <td>4501274</td>
      <td>-185276</td>
      <td>4315999</td>
      <td>SI_Non-industrial</td>
      <td>461092728</td>
      <td>SI_Non-industrial</td>
      <td>3162068</td>
    </tr>
    <tr>
      <th rowspan="3" valign="top">TASM</th>
      <th>KIK</th>
      <td>121754</td>
      <td>0</td>
      <td>121754</td>
      <td>-26544</td>
      <td>95210</td>
      <td>SI_Non-industrial</td>
      <td>14108411</td>
      <td>SI_Non-industrial</td>
      <td>96752</td>
    </tr>
    <tr>
      <th>MCH</th>
      <td>24506</td>
      <td>0</td>
      <td>24506</td>
      <td>-17701</td>
      <td>6805</td>
      <td>SI_Non-industrial</td>
      <td>7988796</td>
      <td>SI_Non-industrial</td>
      <td>54785</td>
    </tr>
    <tr>
      <th>STK</th>
      <td>5653073</td>
      <td>-974432</td>
      <td>4678640</td>
      <td>-1168589</td>
      <td>3510051</td>
      <td>SI_Non-industrial</td>
      <td>558071344</td>
      <td>SI_Non-industrial</td>
      <td>3827125</td>
    </tr>
    <tr>
      <th rowspan="4" valign="top">WATA</th>
      <th>BPT</th>
      <td>243575</td>
      <td>0</td>
      <td>243575</td>
      <td>-52864</td>
      <td>190711</td>
      <td>SI_Non-industrial</td>
      <td>25502976</td>
      <td>SI_Non-industrial</td>
      <td>174894</td>
    </tr>
    <tr>
      <th>OAM</th>
      <td>1464443</td>
      <td>0</td>
      <td>1464443</td>
      <td>-424769</td>
      <td>1039674</td>
      <td>SI_Non-industrial</td>
      <td>202476635</td>
      <td>SI_Non-industrial</td>
      <td>1388538</td>
    </tr>
    <tr>
      <th>TWZ</th>
      <td>87191</td>
      <td>0</td>
      <td>87191</td>
      <td>-25066</td>
      <td>62126</td>
      <td>SI_Non-industrial</td>
      <td>12813948</td>
      <td>SI_Non-industrial</td>
      <td>87875</td>
    </tr>
    <tr>
      <th>WTK</th>
      <td>257854</td>
      <td>0</td>
      <td>257854</td>
      <td>-75079</td>
      <td>182774</td>
      <td>SI_Non-industrial</td>
      <td>35289148</td>
      <td>SI_Non-industrial</td>
      <td>242005</td>
    </tr>
    <tr>
      <th rowspan="5" valign="top">WPOW</th>
      <th>DOB</th>
      <td>60526</td>
      <td>0</td>
      <td>60526</td>
      <td>-24088</td>
      <td>36438</td>
      <td>SI_Non-industrial</td>
      <td>12839527</td>
      <td>SI_Non-industrial</td>
      <td>88051</td>
    </tr>
    <tr>
      <th>GYM</th>
      <td>545335</td>
      <td>0</td>
      <td>545335</td>
      <td>-107037</td>
      <td>438298</td>
      <td>SI_Non-industrial</td>
      <td>56161587</td>
      <td>SI_Non-industrial</td>
      <td>385143</td>
    </tr>
    <tr>
      <th>HKK</th>
      <td>865607</td>
      <td>0</td>
      <td>865607</td>
      <td>-62510</td>
      <td>803097</td>
      <td>SI_Non-industrial</td>
      <td>35324736</td>
      <td>SI_Non-industrial</td>
      <td>242249</td>
    </tr>
    <tr>
      <th>OTI</th>
      <td>58549</td>
      <td>0</td>
      <td>58549</td>
      <td>-2639</td>
      <td>55910</td>
      <td>SI_Non-industrial</td>
      <td>1323464</td>
      <td>SI_Non-industrial</td>
      <td>9076</td>
    </tr>
    <tr>
      <th>RFN</th>
      <td>446543</td>
      <td>0</td>
      <td>446543</td>
      <td>-32707</td>
      <td>413837</td>
      <td>SI_Non-industrial</td>
      <td>20870676</td>
      <td>SI_Non-industrial</td>
      <td>143126</td>
    </tr>
    <tr>
      <th>NZAS</th>
      <th>TWI</th>
      <td>33213043</td>
      <td>0</td>
      <td>33213043</td>
      <td>-2138841</td>
      <td>31074202</td>
      <td>SI_Industrial</td>
      <td>5055112741</td>
      <td>SI_Non-industrial</td>
      <td>34666800</td>
    </tr>
    <tr>
      <th>RAYN</th>
      <th>BDE</th>
      <td>599215</td>
      <td>0</td>
      <td>599215</td>
      <td>-10366</td>
      <td>588849</td>
      <td>SI_Industrial</td>
      <td>57508125</td>
      <td>SI_Non-industrial</td>
      <td>394377</td>
    </tr>
    <tr>
      <th>SOLE</th>
      <th>BDE</th>
      <td>857</td>
      <td>0</td>
      <td>857</td>
      <td>-33</td>
      <td>824</td>
      <td>SI_Industrial</td>
      <td>82296</td>
      <td>SI_Non-industrial</td>
      <td>564</td>
    </tr>
    <tr>
      <th>POWN</th>
      <th>NMA</th>
      <td>2279180</td>
      <td>-2048668</td>
      <td>230513</td>
      <td>-96806</td>
      <td>133706</td>
      <td>SI_load_with_gen</td>
      <td>140202791</td>
      <td>SI_load_with_gen</td>
      <td>133706</td>
    </tr>
  </tbody>
</table>
</div>
<br>

### Determining final regional customer groups (FRCG)

For each Regional supply/demand group (e.g. (NI, supply), (SI, demand)):

 - the provisional customer groups (e.g. NI_wind, NI_peaker, ...) are sorted by 
 the ratio of PVEMBD to IRA, both summed over the group, from highest to lowest.
 - the first provisional group on the list (the one with the highest PVEMBD/IRA) 
 starts the first FRCG. 
 - Working down through the list, if a provisional group has a ratio higher than 
 80% of the previous provisional group, then it joins the same FRCG.

*Output file: ben_groups.csv*
<div class="container" style="max-width: 1000px;">
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th></th>
      <th></th>
      <th>prov_group</th>
      <th>npb</th>
      <th>ira</th>
      <th>future</th>
      <th>ratio</th>
      <th>final_group</th>
    </tr>
    <tr>
      <th>region</th>
      <th>demand_supply</th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td rowspan="7" valign="top">NI</td>
      <td>demand</td>
      <td>NI_Non-industrial</td>
      <td>82346032</td>
      <td>20622148301.82</td>
      <td>False</td>
      <td>3993</td>
      <td>NI_Non-industrial</td>
    </tr>
    <tr>
      <td>demand</td>
      <td>NI_load_with_gen</td>
      <td>3094420</td>
      <td>954069783.14</td>
      <td>False</td>
      <td>3243</td>
      <td>NI_Non-industrial</td>
    </tr>
    <tr>
      <td>demand</td>
      <td>NI_Industrial</td>
      <td>538632</td>
      <td>780004802.20</td>
      <td>False</td>
      <td>691</td>
      <td>NI_Industrial</td>
    </tr>
    <tr>
      <td>supply</td>
      <td>NI_wind</td>
      <td>17778473</td>
      <td>2697243384.60</td>
      <td>False</td>
      <td>6591</td>
      <td>NI_wind</td>
    </tr>
    <tr>
      <td>supply</td>
      <td>NI_cogen</td>
      <td>583257</td>
      <td>151013251.00</td>
      <td>False</td>
      <td>3862</td>
      <td>NI_cogen</td>
    </tr>
    <tr>
      <td>supply</td>
      <td>NI_peaker</td>
      <td>2206010</td>
      <td>1552109155.80</td>
      <td>False</td>
      <td>1421</td>
      <td>NI_peaker</td>
    </tr>
    <tr>
      <td>supply</td>
      <td>NI_commit</td>
      <td>5026703</td>
      <td>3981514051.00</td>
      <td>False</td>
      <td>1263</td>
      <td>NI_peaker</td>
    </tr>
    <tr>
      <td rowspan="4" valign="top">SI</td>
      <td>demand</td>
      <td>SI_Non-industrial</td>
      <td>65770830</td>
      <td>9095225390.30</td>
      <td>False</td>
      <td>7231</td>
      <td>SI_Non-industrial</td>
    </tr>
    <tr>
      <td>demand</td>
      <td>SI_Industrial</td>
      <td>31663874</td>
      <td>5112703162.00</td>
      <td>False</td>
      <td>6193</td>
      <td>SI_Non-industrial</td>
    </tr>
    <tr>
      <td>demand</td>
      <td>SI_load_with_gen</td>
      <td>133706</td>
      <td>140202791.40</td>
      <td>False</td>
      <td>954</td>
      <td>SI_load_with_gen</td>
    </tr>
    <tr>
      <td>supply</td>
      <td>SI_battery</td>
      <td>3547</td>
      <td>74000.00</td>
      <td>True</td>
      <td>47935</td>
      <td>SI_battery</td>
    </tr>
  </tbody>
</table>
</div>

----

## Inputs

Regions: regions_hvdc/region_buses.yaml

clause52 output directory: clause52_output_hvdc_lce_251203_lfd_fix

sddp2tpm_data directory: sddp2tpm_data/data

Renewable projects (for wind repowering adjustments): renewProjects.csv

Weights: {'disruptive': 0.2, 'environmental': 0.2, 'global': 0.2, 'growth': 0.2, 'reference': 0.2}

Output directory: alloc52hvdc_20260116_irafix

----

[^step_loads]: See "Remove PVEMBD for customers or large plant that do not currently exist"
section of assumptions book[^AB]
[^similar]: if the ratio of generation to load benefit is between 0.5 and 1.5
[^NPB]: In this document the terms NPB and PVEMBD are interchangeable.
[^AB]: [Published version of the Assumptions Book](https://www.transpower.co.nz/our-work/industry/grid-pricing/assumptions-book)